/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.ehcache.shadow.org.terracotta.offheapstore.disk.persistent;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.IntBuffer;
import java.nio.MappedByteBuffer;
import java.util.concurrent.locks.Lock;
import org.apache.hadoop.shaded.org.ehcache.shadow.org.terracotta.offheapstore.AbstractLockedOffHeapHashMap;
import org.apache.hadoop.shaded.org.ehcache.shadow.org.terracotta.offheapstore.disk.paging.MappedPageSource;
import org.apache.hadoop.shaded.org.ehcache.shadow.org.terracotta.offheapstore.disk.persistent.Persistent;
import org.apache.hadoop.shaded.org.ehcache.shadow.org.terracotta.offheapstore.disk.persistent.PersistentStorageEngine;
import org.apache.hadoop.shaded.org.ehcache.shadow.org.terracotta.offheapstore.paging.PageSource;
import org.apache.hadoop.shaded.org.ehcache.shadow.org.terracotta.offheapstore.util.FindbugsSuppressWarnings;

public abstract class AbstractPersistentLockedOffHeapHashMap<K, V>
extends AbstractLockedOffHeapHashMap<K, V>
implements Persistent {
    private static final int MAGIC = 1212502615;

    public AbstractPersistentLockedOffHeapHashMap(MappedPageSource tableSource, PersistentStorageEngine<? super K, ? super V> storageEngine, boolean bootstrap) {
        super((PageSource)tableSource, storageEngine, bootstrap);
    }

    public AbstractPersistentLockedOffHeapHashMap(MappedPageSource tableSource, PersistentStorageEngine<? super K, ? super V> storageEngine, int tableSize, boolean bootstrap) {
        super((PageSource)tableSource, storageEngine, tableSize, bootstrap);
    }

    @Override
    public void flush() throws IOException {
        Lock l = this.writeLock();
        l.lock();
        try {
            ((MappedByteBuffer)this.hashTablePage.asByteBuffer()).force();
            ((Persistent)((Object)this.storageEngine)).flush();
        }
        finally {
            l.unlock();
        }
    }

    @Override
    public void close() throws IOException {
        Lock l = this.writeLock();
        l.lock();
        try {
            ((MappedPageSource)this.tableSource).close();
            ((Persistent)((Object)this.storageEngine)).close();
        }
        finally {
            l.unlock();
        }
    }

    @Override
    public void persist(ObjectOutput output) throws IOException {
        Lock l = this.writeLock();
        l.lock();
        try {
            output.writeInt(1212502615);
            output.writeLong(((MappedPageSource)this.tableSource).getAddress(this.hashTablePage));
            output.writeInt(this.hashTablePage.size());
            output.writeInt(this.reprobeLimit);
            ((Persistent)((Object)this.storageEngine)).persist(output);
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @FindbugsSuppressWarnings(value={"VO_VOLATILE_INCREMENT"})
    public void bootstrap(ObjectInput input) throws IOException {
        Lock l = this.writeLock();
        l.lock();
        try {
            if (this.hashtable != null) {
                throw new IllegalStateException();
            }
            if (input.readInt() != 1212502615) {
                throw new IOException("Wrong magic number");
            }
            long tableAddress = input.readLong();
            long tableCapacity = input.readInt();
            this.hashTablePage = ((MappedPageSource)this.tableSource).claimPage(tableAddress, tableCapacity);
            this.hashtable = this.hashTablePage.asIntBuffer();
            this.reprobeLimit = input.readInt();
            this.hashtable.clear();
            while (this.hashtable.hasRemaining()) {
                IntBuffer entry = (IntBuffer)this.hashtable.slice().limit(4);
                if (AbstractPersistentLockedOffHeapHashMap.isPresent(entry)) {
                    ++this.size;
                    this.added(this.hashtable.position(), entry);
                } else if (AbstractPersistentLockedOffHeapHashMap.isRemoved(entry)) {
                    ++this.removedSlots;
                }
                this.hashtable.position(this.hashtable.position() + 4);
            }
            ((Persistent)((Object)this.storageEngine)).bootstrap(input);
        }
        finally {
            l.unlock();
        }
    }
}

