/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.concurrent;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

final class DaemonFactory
implements ThreadFactory {
    static final DaemonFactory INSTANCE = new DaemonFactory();
    private static final String OJALGO_DAEMON_GROUP = "ojAlgo-daemon-group";
    private static final String PREFIX = "ojAlgo-daemon-";
    private static final int PRIORITY = 4;
    private final AtomicInteger myNextThreadID = new AtomicInteger(1);
    private final ThreadGroup myThreadGroup = new ThreadGroup("ojAlgo-daemon-group");

    private DaemonFactory() {
    }

    @Override
    public Thread newThread(Runnable runnable) {
        String tmpName = PREFIX + this.myNextThreadID.getAndIncrement();
        Thread retVal = new Thread(this.myThreadGroup, runnable, tmpName);
        retVal.setDaemon(true);
        retVal.setPriority(4);
        return retVal;
    }
}

