/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import org.nustaq.serialization.FSTClazzInfo;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.FSTObjectInput;

public class FSTObjectInputNoShared
extends FSTObjectInput {
    public FSTObjectInputNoShared() throws IOException {
    }

    public FSTObjectInputNoShared(FSTConfiguration conf) {
        super(conf);
        conf.setShareReferences(false);
    }

    public FSTObjectInputNoShared(InputStream in) throws IOException {
        super(in);
    }

    public FSTObjectInputNoShared(InputStream in, FSTConfiguration conf) {
        super(in, conf);
    }

    @Override
    public void registerObject(Object o, int streamPosition, FSTClazzInfo info, FSTClazzInfo.FSTFieldInfo referencee) {
    }

    @Override
    public void resetForReuse(InputStream in) throws IOException {
        if (this.closed) {
            throw new RuntimeException("can't reuse closed stream");
        }
        this.getCodec().reset();
        this.getCodec().setInputStream(in);
    }

    @Override
    public void resetForReuseCopyArray(byte[] bytes, int off, int len) throws IOException {
        if (this.closed) {
            throw new RuntimeException("can't reuse closed stream");
        }
        this.getCodec().reset();
        this.getCodec().resetToCopyOf(bytes, off, len);
    }

    @Override
    protected Object instantiateAndReadNoSer(Class c, FSTClazzInfo clzSerInfo, FSTClazzInfo.FSTFieldInfo referencee, int readPos) throws Exception {
        Object newObj = clzSerInfo.newInstance(this.getCodec().isMapBased());
        if (newObj == null) {
            throw new IOException(referencee.getDesc() + ":Failed to instantiate '" + c.getName() + "'. Register a custom serializer implementing instantiate or define empty constructor..");
        }
        if (clzSerInfo.isExternalizable()) {
            this.getCodec().ensureReadAhead(this.readExternalReadAHead);
            ((Externalizable)newObj).readExternal(this);
            this.getCodec().readExternalEnd();
        } else {
            FSTClazzInfo.FSTFieldInfo[] fieldInfo = clzSerInfo.getFieldInfo();
            this.readObjectFields(referencee, clzSerInfo, fieldInfo, newObj, 0, 0);
        }
        return newObj;
    }
}

