/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.hadoop.oncrpc.RpcProgram;
import org.apache.hadoop.oncrpc.RpcUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTcpServer {
    public static final Logger LOG = LoggerFactory.getLogger(SimpleTcpServer.class);
    protected final int port;
    protected int boundPort = -1;
    protected final ChannelInboundHandlerAdapter rpcProgram;
    private ServerBootstrap server;
    private Channel ch;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    protected final int workerCount;

    public SimpleTcpServer(int port, RpcProgram program, int workercount) {
        this.port = port;
        this.rpcProgram = program;
        this.workerCount = workercount;
    }

    public void run() throws InterruptedException {
        this.bossGroup = new NioEventLoopGroup();
        this.workerGroup = new NioEventLoopGroup(this.workerCount, (Executor)Executors.newCachedThreadPool());
        this.server = new ServerBootstrap();
        ((ServerBootstrap)this.server.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                p.addLast(new ChannelHandler[]{RpcUtil.constructRpcFrameDecoder(), RpcUtil.STAGE_RPC_MESSAGE_PARSER, SimpleTcpServer.this.rpcProgram, RpcUtil.STAGE_RPC_TCP_RESPONSE});
            }
        }).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childOption(ChannelOption.SO_REUSEADDR, (Object)true).option(ChannelOption.SO_REUSEADDR, (Object)true);
        ChannelFuture f = this.server.bind((SocketAddress)new InetSocketAddress(this.port)).sync();
        this.ch = f.channel();
        InetSocketAddress socketAddr = (InetSocketAddress)this.ch.localAddress();
        this.boundPort = socketAddr.getPort();
        LOG.info("Started listening to TCP requests at port " + this.boundPort + " for " + this.rpcProgram + " with workerCount " + this.workerCount);
    }

    public int getBoundPort() {
        return this.boundPort;
    }

    public void shutdown() {
        if (this.ch != null) {
            this.ch.close().awaitUninterruptibly();
            this.ch = null;
        }
        if (this.workerGroup != null) {
            this.workerGroup.shutdownGracefully();
            this.workerGroup = null;
        }
        if (this.bossGroup != null) {
            this.bossGroup.shutdownGracefully();
            this.bossGroup = null;
        }
    }
}

