/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.KDiag;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.rules.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestKDiagNoKDC
extends Assert {
    private static final Logger LOG = LoggerFactory.getLogger(TestKDiagNoKDC.class);
    public static final String KEYLEN = "128";
    @Rule
    public TestName methodName = new TestName();
    @Rule
    public Timeout testTimeout = new Timeout(30000L, TimeUnit.MILLISECONDS);
    private static Configuration conf = new Configuration();

    @BeforeClass
    public static void nameThread() {
        Thread.currentThread().setName("JUnit");
    }

    @Before
    public void reset() {
        UserGroupInformation.reset();
    }

    void kdiagFailure(String category, String ... args) throws Exception {
        block2: {
            try {
                int ex = KDiag.exec((Configuration)conf, (String[])args);
                LOG.error("Expected an exception in category {}, return code {}", (Object)category, (Object)ex);
            }
            catch (KDiag.KerberosDiagsFailure e) {
                if (e.getCategory().equals(category)) break block2;
                LOG.error("Expected an exception in category {}, got {}", new Object[]{category, e, e});
                throw e;
            }
        }
    }

    int kdiag(String ... args) throws Exception {
        return KDiag.exec((Configuration)conf, (String[])args);
    }

    @Test
    public void testKDiagStandalone() throws Throwable {
        this.kdiagFailure("LOGIN", "--keylen", KEYLEN);
    }

    @Test
    public void testKDiagNoLogin() throws Throwable {
        this.kdiagFailure("LOGIN", "--keylen", KEYLEN, "--nologin");
    }

    @Test
    public void testKDiagStandaloneNofail() throws Throwable {
        this.kdiag("--keylen", KEYLEN, "--nofail");
    }

    @Test
    public void testKDiagUsage() throws Throwable {
        TestKDiagNoKDC.assertEquals((long)-1L, (long)this.kdiag("usage"));
    }

    @Test
    public void testTokenFile() throws Throwable {
        conf.set("hadoop.token.files", "SomeNonExistentFile");
        this.kdiagFailure("TOKEN", "--keylen", KEYLEN);
        conf.unset("hadoop.token.files");
    }
}

