/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.statistics;

import org.apache.hadoop.fs.statistics.IOStatisticAssertions;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsLogging;
import org.apache.hadoop.fs.statistics.IOStatisticsSnapshot;
import org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.apache.hadoop.fs.statistics.MeanStatistic;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.apache.hadoop.test.AbstractHadoopTestBase;
import org.apache.hadoop.util.JsonSerialization;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestIOStatisticsSnapshot
extends AbstractHadoopTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestIOStatisticsSnapshot.class);
    private final IOStatisticsSnapshot snapshot = new IOStatisticsSnapshot();
    private MeanStatistic mean0;
    private MeanStatistic mean1;

    @Before
    public void setup() throws Exception {
        this.snapshot.counters().put("c1", 0L);
        this.snapshot.gauges().put("g1", 1L);
        this.snapshot.minimums().put("m1", -1L);
        this.mean1 = new MeanStatistic(1L, 1L);
        this.snapshot.meanStatistics().put("mean1", this.mean1);
        this.mean0 = new MeanStatistic(0L, 1L);
        this.snapshot.meanStatistics().put("mean0", this.mean0);
    }

    @Test
    public void testTrackedValues() throws Throwable {
        IOStatisticAssertions.verifyStatisticCounterValue((IOStatistics)this.snapshot, "c1", 0L);
        IOStatisticAssertions.verifyStatisticGaugeValue((IOStatistics)this.snapshot, "g1", 1L);
        IOStatisticAssertions.verifyStatisticMinimumValue((IOStatistics)this.snapshot, "m1", -1L);
        IOStatisticAssertions.verifyStatisticMeanValue((IOStatistics)this.snapshot, "mean0", new MeanStatistic(0L, 1L));
    }

    @Test
    public void testStatisticsValueAssertion() throws Throwable {
        Assertions.assertThatThrownBy(() -> IOStatisticAssertions.verifyStatisticCounterValue((IOStatistics)this.snapshot, "anything", 0L)).isInstanceOf(AssertionError.class);
    }

    @Test
    public void testStringification() throws Throwable {
        Assertions.assertThat((String)IOStatisticsLogging.ioStatisticsToString((IOStatistics)this.snapshot)).isNotBlank();
    }

    @Test
    public void testStringification2() throws Throwable {
        String ss = this.snapshot.toString();
        LOG.info("original {}", (Object)ss);
        ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)ss).describedAs("snapshot toString()", new Object[0])).contains(new CharSequence[]{"c1=0"})).contains(new CharSequence[]{"g1=1"});
    }

    @Test
    public void testWrap() throws Throwable {
        IOStatisticsSource statisticsSource = IOStatisticsBinding.wrap((IOStatistics)this.snapshot);
        Assertions.assertThat((Object)statisticsSource.getIOStatistics()).isSameAs((Object)this.snapshot);
    }

    @Test
    public void testJsonRoundTrip() throws Throwable {
        JsonSerialization serializer = IOStatisticsSnapshot.serializer();
        String json = serializer.toJson((Object)this.snapshot);
        LOG.info("serialized form\n{}", (Object)json);
        IOStatisticsSnapshot deser = (IOStatisticsSnapshot)serializer.fromJson(json);
        this.verifyDeserializedInstance((IOStatistics)deser);
    }

    public void verifyDeserializedInstance(IOStatistics deser) {
        LOG.info("deserialized {}", (Object)deser);
        IOStatisticAssertions.verifyStatisticCounterValue(deser, "c1", 0L);
        IOStatisticAssertions.verifyStatisticGaugeValue(deser, "g1", 1L);
        IOStatisticAssertions.verifyStatisticMinimumValue(deser, "m1", -1L);
        IOStatisticAssertions.verifyStatisticMeanValue(deser, "mean0", new MeanStatistic(0L, 1L));
        IOStatisticAssertions.verifyStatisticMeanValue(deser, "mean1", (MeanStatistic)this.snapshot.meanStatistics().get("mean1"));
    }

    @Test
    public void testJavaRoundTrip() throws Throwable {
        this.verifyDeserializedInstance(IOStatisticAssertions.statisticsJavaRoundTrip((IOStatistics)this.snapshot));
    }
}

