/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Date;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.AccumulatingReducer;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.IOMapperBase;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore
public class DFSCIOTest {
    private static final Logger LOG = LoggerFactory.getLogger(DFSCIOTest.class);
    private static final int TEST_TYPE_READ = 0;
    private static final int TEST_TYPE_WRITE = 1;
    private static final int TEST_TYPE_CLEANUP = 2;
    private static final int DEFAULT_BUFFER_SIZE = 1000000;
    private static final String BASE_FILE_NAME = "test_io_";
    private static final String DEFAULT_RES_FILE_NAME = "DFSCIOTest_results.log";
    private static Configuration fsConfig = new Configuration();
    private static final long MEGA = 0x100000L;
    private static String TEST_ROOT_DIR = System.getProperty("test.build.data", "/benchmarks/DFSCIOTest");
    private static Path CONTROL_DIR = new Path(TEST_ROOT_DIR, "io_control");
    private static Path WRITE_DIR = new Path(TEST_ROOT_DIR, "io_write");
    private static Path READ_DIR = new Path(TEST_ROOT_DIR, "io_read");
    private static Path DATA_DIR = new Path(TEST_ROOT_DIR, "io_data");
    private static Path HDFS_TEST_DIR = new Path("/tmp/DFSCIOTest");
    private static String HDFS_LIB_VERSION = System.getProperty("libhdfs.version", "1");
    private static String CHMOD = new String("chmod");
    private static Path HDFS_SHLIB = new Path(HDFS_TEST_DIR + "/libhdfs.so." + HDFS_LIB_VERSION);
    private static Path HDFS_READ = new Path(HDFS_TEST_DIR + "/hdfs_read");
    private static Path HDFS_WRITE = new Path(HDFS_TEST_DIR + "/hdfs_write");

    @Test
    public void testIOs() throws Exception {
        DFSCIOTest.testIOs(10, 10);
    }

    public static void testIOs(int fileSize, int nrFiles) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)fsConfig);
        DFSCIOTest.createControlFile(fs, fileSize, nrFiles);
        DFSCIOTest.writeTest(fs);
        DFSCIOTest.readTest(fs);
    }

    private static void createControlFile(FileSystem fs, int fileSize, int nrFiles) throws IOException {
        LOG.info("creating control file: " + fileSize + " mega bytes, " + nrFiles + " files");
        fs.delete(CONTROL_DIR, true);
        for (int i = 0; i < nrFiles; ++i) {
            String name = DFSCIOTest.getFileName(i);
            Path controlFile = new Path(CONTROL_DIR, "in_file_" + name);
            SequenceFile.Writer writer = null;
            try {
                writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)fsConfig, (Path)controlFile, Text.class, LongWritable.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE);
                writer.append((Writable)new Text(name), (Writable)new LongWritable((long)fileSize));
                continue;
            }
            catch (Exception e) {
                throw new IOException(e.getLocalizedMessage());
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
                writer = null;
            }
        }
        LOG.info("created control files for: " + nrFiles + " files");
    }

    private static String getFileName(int fIdx) {
        return BASE_FILE_NAME + Integer.toString(fIdx);
    }

    private static void writeTest(FileSystem fs) throws IOException {
        fs.delete(DATA_DIR, true);
        fs.delete(WRITE_DIR, true);
        DFSCIOTest.runIOTest(WriteMapper.class, WRITE_DIR);
    }

    private static void runIOTest(Class<? extends Mapper> mapperClass, Path outputDir) throws IOException {
        JobConf job = new JobConf(fsConfig, DFSCIOTest.class);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{CONTROL_DIR});
        job.setInputFormat(SequenceFileInputFormat.class);
        job.setMapperClass(mapperClass);
        job.setReducerClass(AccumulatingReducer.class);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)outputDir);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setNumReduceTasks(1);
        JobClient.runJob((JobConf)job);
    }

    private static void readTest(FileSystem fs) throws IOException {
        fs.delete(READ_DIR, true);
        DFSCIOTest.runIOTest(ReadMapper.class, READ_DIR);
    }

    private static void sequentialTest(FileSystem fs, int testType, int fileSize, int nrFiles) throws Exception {
        IOStatMapper ioer = null;
        if (testType == 0) {
            ioer = new ReadMapper();
        } else if (testType == 1) {
            ioer = new WriteMapper();
        } else {
            return;
        }
        for (int i = 0; i < nrFiles; ++i) {
            ioer.doIO(Reporter.NULL, BASE_FILE_NAME + Integer.toString(i), 0x100000L * (long)fileSize);
        }
    }

    public static void main(String[] args) {
        int testType = 0;
        int bufferSize = 1000000;
        int fileSize = 1;
        int nrFiles = 1;
        String resFileName = DEFAULT_RES_FILE_NAME;
        boolean isSequential = false;
        String version = "DFSCIOTest.0.0.1";
        String usage = "Usage: DFSCIOTest -read | -write | -clean [-nrFiles N] [-fileSize MB] [-resFile resultFileName] [-bufferSize Bytes] ";
        System.out.println(version);
        if (args.length == 0) {
            System.err.println(usage);
            System.exit(-1);
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-r")) {
                testType = 0;
                continue;
            }
            if (args[i].startsWith("-w")) {
                testType = 1;
                continue;
            }
            if (args[i].startsWith("-clean")) {
                testType = 2;
                continue;
            }
            if (args[i].startsWith("-seq")) {
                isSequential = true;
                continue;
            }
            if (args[i].equals("-nrFiles")) {
                nrFiles = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-fileSize")) {
                fileSize = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-bufferSize")) {
                bufferSize = Integer.parseInt(args[++i]);
                continue;
            }
            if (!args[i].equals("-resFile")) continue;
            resFileName = args[++i];
        }
        LOG.info("nrFiles = " + nrFiles);
        LOG.info("fileSize (MB) = " + fileSize);
        LOG.info("bufferSize = " + bufferSize);
        try {
            fsConfig.setInt("test.io.file.buffer.size", bufferSize);
            FileSystem fs = FileSystem.get((Configuration)fsConfig);
            if (testType != 2) {
                fs.delete(HDFS_TEST_DIR, true);
                if (!fs.mkdirs(HDFS_TEST_DIR)) {
                    throw new IOException("Mkdirs failed to create " + HDFS_TEST_DIR.toString());
                }
                String hadoopHome = System.getenv("HADOOP_HOME");
                fs.copyFromLocalFile(new Path(hadoopHome + "/libhdfs/libhdfs.so." + HDFS_LIB_VERSION), HDFS_SHLIB);
                fs.copyFromLocalFile(new Path(hadoopHome + "/libhdfs/hdfs_read"), HDFS_READ);
                fs.copyFromLocalFile(new Path(hadoopHome + "/libhdfs/hdfs_write"), HDFS_WRITE);
            }
            if (isSequential) {
                long tStart = System.currentTimeMillis();
                DFSCIOTest.sequentialTest(fs, testType, fileSize, nrFiles);
                long execTime = System.currentTimeMillis() - tStart;
                String resultLine = "Seq Test exec time sec: " + (float)execTime / 1000.0f;
                LOG.info(resultLine);
                return;
            }
            if (testType == 2) {
                DFSCIOTest.cleanup(fs);
                return;
            }
            DFSCIOTest.createControlFile(fs, fileSize, nrFiles);
            long tStart = System.currentTimeMillis();
            if (testType == 1) {
                DFSCIOTest.writeTest(fs);
            }
            if (testType == 0) {
                DFSCIOTest.readTest(fs);
            }
            long execTime = System.currentTimeMillis() - tStart;
            DFSCIOTest.analyzeResult(fs, testType, execTime, resFileName);
        }
        catch (Exception e) {
            System.err.print(e.getLocalizedMessage());
            System.exit(-1);
        }
    }

    private static void analyzeResult(FileSystem fs, int testType, long execTime, String resFileName) throws IOException {
        String line;
        Path reduceFile = testType == 1 ? new Path(WRITE_DIR, "part-00000") : new Path(READ_DIR, "part-00000");
        DataInputStream in = new DataInputStream((InputStream)fs.open(reduceFile));
        BufferedReader lines = new BufferedReader(new InputStreamReader(in));
        long tasks = 0L;
        long size = 0L;
        long time = 0L;
        float rate = 0.0f;
        float sqrate = 0.0f;
        while ((line = lines.readLine()) != null) {
            StringTokenizer tokens = new StringTokenizer(line, " \t\n\r\f%");
            String attr = tokens.nextToken();
            if (attr.endsWith(":tasks")) {
                tasks = Long.parseLong(tokens.nextToken());
                continue;
            }
            if (attr.endsWith(":size")) {
                size = Long.parseLong(tokens.nextToken());
                continue;
            }
            if (attr.endsWith(":time")) {
                time = Long.parseLong(tokens.nextToken());
                continue;
            }
            if (attr.endsWith(":rate")) {
                rate = Float.parseFloat(tokens.nextToken());
                continue;
            }
            if (!attr.endsWith(":sqrate")) continue;
            sqrate = Float.parseFloat(tokens.nextToken());
        }
        double med = rate / 1000.0f / (float)tasks;
        double stdDev = Math.sqrt(Math.abs((double)(sqrate / 1000.0f / (float)tasks) - med * med));
        String[] resultLines = new String[]{"----- DFSCIOTest ----- : " + (testType == 1 ? "write" : (testType == 0 ? "read" : "unknown")), "           Date & time: " + new Date(System.currentTimeMillis()), "       Number of files: " + tasks, "Total MBytes processed: " + size / 0x100000L, "     Throughput mb/sec: " + (double)size * 1000.0 / (double)(time * 0x100000L), "Average IO rate mb/sec: " + med, " Std IO rate deviation: " + stdDev, "    Test exec time sec: " + (float)execTime / 1000.0f, ""};
        PrintStream res = new PrintStream(new FileOutputStream(new File(resFileName), true));
        for (int i = 0; i < resultLines.length; ++i) {
            LOG.info(resultLines[i]);
            res.println(resultLines[i]);
        }
    }

    private static void cleanup(FileSystem fs) throws Exception {
        LOG.info("Cleaning up test files");
        fs.delete(new Path(TEST_ROOT_DIR), true);
        fs.delete(HDFS_TEST_DIR, true);
    }

    public static class ReadMapper
    extends IOStatMapper {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Long doIO(Reporter reporter, String name, long totalSize) throws IOException {
            totalSize *= 0x100000L;
            try (LocalFileSystem localFS = FileSystem.getLocal((Configuration)fsConfig);){
                int exitStatus;
                Process process;
                String chmodCmd;
                Runtime runTime = Runtime.getRuntime();
                ReadMapper readMapper = this;
                synchronized (readMapper) {
                    localFS.delete(HDFS_TEST_DIR, true);
                    if (!localFS.mkdirs(HDFS_TEST_DIR)) {
                        throw new IOException("Failed to create " + HDFS_TEST_DIR + " on local filesystem");
                    }
                }
                readMapper = this;
                synchronized (readMapper) {
                    if (!localFS.exists(HDFS_SHLIB)) {
                        if (!FileUtil.copy((FileSystem)this.fs, (Path)HDFS_SHLIB, (FileSystem)localFS, (Path)HDFS_SHLIB, (boolean)false, (Configuration)fsConfig)) {
                            throw new IOException("Failed to copy " + HDFS_SHLIB + " to local filesystem");
                        }
                        chmodCmd = new String(CHMOD + " a+x " + HDFS_SHLIB);
                        process = runTime.exec(chmodCmd);
                        exitStatus = process.waitFor();
                        if (exitStatus != 0) {
                            throw new IOException(chmodCmd + ": Failed with exitStatus: " + exitStatus);
                        }
                    }
                }
                readMapper = this;
                synchronized (readMapper) {
                    if (!localFS.exists(HDFS_READ)) {
                        if (!FileUtil.copy((FileSystem)this.fs, (Path)HDFS_READ, (FileSystem)localFS, (Path)HDFS_READ, (boolean)false, (Configuration)fsConfig)) {
                            throw new IOException("Failed to copy " + HDFS_READ + " to local filesystem");
                        }
                        chmodCmd = new String(CHMOD + " a+x " + HDFS_READ);
                        process = runTime.exec(chmodCmd);
                        exitStatus = process.waitFor();
                        if (exitStatus != 0) {
                            throw new IOException(chmodCmd + ": Failed with exitStatus: " + exitStatus);
                        }
                    }
                }
                Path inFile = new Path(DATA_DIR, name);
                String readCmd = new String(HDFS_READ + " " + inFile + " " + totalSize + " " + this.bufferSize);
                process = runTime.exec(readCmd, null, new File(HDFS_TEST_DIR.toString()));
                exitStatus = process.waitFor();
                if (exitStatus != 0) {
                    throw new IOException(HDFS_READ + ": Failed with exitStatus: " + exitStatus);
                }
            }
            return new Long(totalSize);
        }
    }

    public static class WriteMapper
    extends IOStatMapper {
        public WriteMapper() {
            for (int i = 0; i < this.bufferSize; ++i) {
                this.buffer[i] = (byte)(48 + i % 50);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Long doIO(Reporter reporter, String name, long totalSize) throws IOException {
            totalSize *= 0x100000L;
            try (LocalFileSystem localFS = FileSystem.getLocal((Configuration)fsConfig);){
                int exitStatus;
                Process process;
                String chmodCmd;
                Runtime runTime = Runtime.getRuntime();
                WriteMapper writeMapper = this;
                synchronized (writeMapper) {
                    localFS.delete(HDFS_TEST_DIR, true);
                    if (!localFS.mkdirs(HDFS_TEST_DIR)) {
                        throw new IOException("Failed to create " + HDFS_TEST_DIR + " on local filesystem");
                    }
                }
                writeMapper = this;
                synchronized (writeMapper) {
                    if (!localFS.exists(HDFS_SHLIB)) {
                        FileUtil.copy((FileSystem)this.fs, (Path)HDFS_SHLIB, (FileSystem)localFS, (Path)HDFS_SHLIB, (boolean)false, (Configuration)fsConfig);
                        chmodCmd = new String(CHMOD + " a+x " + HDFS_SHLIB);
                        process = runTime.exec(chmodCmd);
                        exitStatus = process.waitFor();
                        if (exitStatus != 0) {
                            throw new IOException(chmodCmd + ": Failed with exitStatus: " + exitStatus);
                        }
                    }
                }
                writeMapper = this;
                synchronized (writeMapper) {
                    if (!localFS.exists(HDFS_WRITE)) {
                        FileUtil.copy((FileSystem)this.fs, (Path)HDFS_WRITE, (FileSystem)localFS, (Path)HDFS_WRITE, (boolean)false, (Configuration)fsConfig);
                        chmodCmd = new String(CHMOD + " a+x " + HDFS_WRITE);
                        process = runTime.exec(chmodCmd);
                        exitStatus = process.waitFor();
                        if (exitStatus != 0) {
                            throw new IOException(chmodCmd + ": Failed with exitStatus: " + exitStatus);
                        }
                    }
                }
                Path outFile = new Path(DATA_DIR, name);
                String writeCmd = new String(HDFS_WRITE + " " + outFile + " " + totalSize + " " + this.bufferSize);
                process = runTime.exec(writeCmd, null, new File(HDFS_TEST_DIR.toString()));
                exitStatus = process.waitFor();
                if (exitStatus != 0) {
                    throw new IOException(writeCmd + ": Failed with exitStatus: " + exitStatus);
                }
            }
            return new Long(totalSize);
        }
    }

    private static abstract class IOStatMapper
    extends IOMapperBase<Long> {
        IOStatMapper() {
        }

        @Override
        void collectStats(OutputCollector<Text, Text> output, String name, long execTime, Long objSize) throws IOException {
            long totalSize = objSize;
            float ioRateMbSec = (float)totalSize * 1000.0f / (float)(execTime * 0x100000L);
            LOG.info("Number of bytes processed = " + totalSize);
            LOG.info("Exec time = " + execTime);
            LOG.info("IO rate = " + ioRateMbSec);
            output.collect((Object)new Text("l:tasks"), (Object)new Text(String.valueOf(1)));
            output.collect((Object)new Text("l:size"), (Object)new Text(String.valueOf(totalSize)));
            output.collect((Object)new Text("l:time"), (Object)new Text(String.valueOf(execTime)));
            output.collect((Object)new Text("f:rate"), (Object)new Text(String.valueOf(ioRateMbSec * 1000.0f)));
            output.collect((Object)new Text("f:sqrate"), (Object)new Text(String.valueOf(ioRateMbSec * ioRateMbSec * 1000.0f)));
        }
    }
}

