/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.common;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class Range {
    private final int startIdx;
    private final int endIdx;

    public Range(int start, int end) {
        if (start < 0 || end < start) {
            throw new IllegalArgumentException("Invalid range, required that: 0 <= start <= end; start=" + start + ", end=" + end);
        }
        this.startIdx = start;
        this.endIdx = end;
    }

    public int start() {
        return this.startIdx;
    }

    public int end() {
        return this.endIdx;
    }

    public int length() {
        return this.endIdx - this.startIdx;
    }
}

