/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.ha.ServiceFailedException;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSClientAdapter;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenSecretManager;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestFailoverWithBlockTokensEnabled {
    private static final Path TEST_PATH = new Path("/test-path");
    private static final String TEST_DATA = "very important text";
    private static final int numNNs = 3;
    private Configuration conf;
    private MiniDFSCluster cluster;

    @Before
    public void startCluster() throws IOException {
        this.conf = new Configuration();
        this.conf.setBoolean("dfs.block.access.token.enable", true);
        this.conf.setInt("dfs.client.retry.window.base", 10);
        this.cluster = new MiniDFSCluster.Builder(this.conf).nnTopology(MiniDFSNNTopology.simpleHATopology(3)).numDataNodes(1).build();
    }

    @After
    public void shutDownCluster() {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    public void ensureSerialNumbersNeverOverlap() {
        BlockTokenSecretManager btsm1 = this.cluster.getNamesystem(0).getBlockManager().getBlockTokenSecretManager();
        BlockTokenSecretManager btsm2 = this.cluster.getNamesystem(1).getBlockManager().getBlockTokenSecretManager();
        BlockTokenSecretManager btsm3 = this.cluster.getNamesystem(2).getBlockManager().getBlockTokenSecretManager();
        this.setAndCheckSerialNumber(0, btsm1, btsm2, btsm3);
        this.setAndCheckSerialNumber(Integer.MAX_VALUE, btsm1, btsm2, btsm3);
        this.setAndCheckSerialNumber(0x3FFFFFFF, btsm1, btsm2, btsm3);
        this.setAndCheckSerialNumber(0x2AAAAAAA, btsm1, btsm2, btsm3);
        this.setAndCheckSerialNumber(12505, btsm1, btsm2, btsm3);
    }

    private void setAndCheckSerialNumber(int serialNumber, BlockTokenSecretManager ... btsms) {
        for (BlockTokenSecretManager btsm : btsms) {
            btsm.setSerialNo(serialNumber);
        }
        for (int i = 0; i < btsms.length; ++i) {
            for (int j = 0; j < btsms.length; ++j) {
                if (j == i) continue;
                int first = btsms[i].getSerialNoForTesting();
                int second = btsms[j].getSerialNoForTesting();
                Assert.assertFalse((String)("Overlap found for set serial number (" + serialNumber + ") is " + i + ": " + first + " == " + j + ": " + second), (first == second ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void ensureInvalidBlockTokensAreRejected() throws IOException, URISyntaxException {
        this.cluster.transitionToActive(0);
        DistributedFileSystem fs = HATestUtil.configureFailoverFs(this.cluster, this.conf);
        DFSTestUtil.writeFile((FileSystem)fs, TEST_PATH, TEST_DATA);
        Assert.assertEquals((Object)TEST_DATA, (Object)DFSTestUtil.readFile((FileSystem)fs, TEST_PATH));
        DFSClient dfsClient = DFSClientAdapter.getDFSClient(fs);
        DFSClient spyDfsClient = (DFSClient)Mockito.spy((Object)dfsClient);
        ((DFSClient)Mockito.doAnswer((Answer)new Answer<LocatedBlocks>(){

            public LocatedBlocks answer(InvocationOnMock arg0) throws Throwable {
                LocatedBlocks locatedBlocks = (LocatedBlocks)arg0.callRealMethod();
                for (LocatedBlock lb : locatedBlocks.getLocatedBlocks()) {
                    Token token = lb.getBlockToken();
                    BlockTokenIdentifier id = (BlockTokenIdentifier)lb.getBlockToken().decodeIdentifier();
                    id.setExpiryDate(Time.now() + 10L);
                    Token newToken = new Token(id.getBytes(), token.getPassword(), token.getKind(), token.getService());
                    lb.setBlockToken(newToken);
                }
                return locatedBlocks;
            }
        }).when((Object)spyDfsClient)).getLocatedBlocks(Mockito.anyString(), Mockito.anyLong(), Mockito.anyLong());
        DFSClientAdapter.setDFSClient(fs, spyDfsClient);
        try {
            Assert.assertEquals((Object)TEST_DATA, (Object)DFSTestUtil.readFile((FileSystem)fs, TEST_PATH));
            Assert.fail((String)"Shouldn't have been able to read a file with invalid block tokens");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"Could not obtain block", (Throwable)ioe);
        }
    }

    @Test
    public void testFailoverAfterRegistration() throws IOException, URISyntaxException {
        this.writeUsingBothNameNodes();
    }

    @Test
    public void TestFailoverAfterAccessKeyUpdate() throws IOException, URISyntaxException, InterruptedException {
        TestFailoverWithBlockTokensEnabled.lowerKeyUpdateIntervalAndClearKeys(this.cluster);
        Thread.sleep(10000L);
        this.writeUsingBothNameNodes();
    }

    private void writeUsingBothNameNodes() throws ServiceFailedException, IOException, URISyntaxException {
        this.cluster.transitionToActive(0);
        DistributedFileSystem fs = HATestUtil.configureFailoverFs(this.cluster, this.conf);
        DFSTestUtil.writeFile((FileSystem)fs, TEST_PATH, TEST_DATA);
        this.cluster.transitionToStandby(0);
        this.cluster.transitionToActive(1);
        fs.delete(TEST_PATH, false);
        DFSTestUtil.writeFile((FileSystem)fs, TEST_PATH, TEST_DATA);
    }

    private static void lowerKeyUpdateIntervalAndClearKeys(MiniDFSCluster cluster) {
        TestFailoverWithBlockTokensEnabled.lowerKeyUpdateIntervalAndClearKeys(cluster.getNamesystem(0));
        TestFailoverWithBlockTokensEnabled.lowerKeyUpdateIntervalAndClearKeys(cluster.getNamesystem(1));
        for (DataNode dn : cluster.getDataNodes()) {
            dn.clearAllBlockSecretKeys();
        }
    }

    private static void lowerKeyUpdateIntervalAndClearKeys(FSNamesystem namesystem) {
        BlockTokenSecretManager btsm = namesystem.getBlockManager().getBlockTokenSecretManager();
        btsm.setKeyUpdateIntervalForTesting(2000L);
        btsm.setTokenLifetime(2000L);
        btsm.clearAllKeysForTesting();
    }
}

