/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.NameNodeProxies;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocolPB.ClientDatanodeProtocolTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.ClientNamenodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.InterDatanodeProtocolTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.JournalProtocolTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.NamenodeProtocolPB;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.protocol.JournalProtocol;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RefreshCallQueueProtocol;
import org.apache.hadoop.ipc.RpcClientUtil;
import org.apache.hadoop.ipc.protocolPB.RefreshCallQueueProtocolClientSideTranslatorPB;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.RefreshUserMappingsProtocol;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.RefreshAuthorizationPolicyProtocol;
import org.apache.hadoop.security.protocolPB.RefreshAuthorizationPolicyProtocolClientSideTranslatorPB;
import org.apache.hadoop.security.protocolPB.RefreshUserMappingsProtocolClientSideTranslatorPB;
import org.apache.hadoop.tools.GetUserMappingsProtocol;
import org.apache.hadoop.tools.protocolPB.GetUserMappingsProtocolClientSideTranslatorPB;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestIsMethodSupported {
    private static MiniDFSCluster cluster = null;
    private static final HdfsConfiguration conf = new HdfsConfiguration();
    private static InetSocketAddress nnAddress = null;
    private static InetSocketAddress dnAddress = null;

    @BeforeClass
    public static void setUp() throws Exception {
        cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        nnAddress = cluster.getNameNode().getNameNodeAddress();
        DataNode dn = cluster.getDataNodes().get(0);
        dnAddress = new InetSocketAddress(dn.getDatanodeId().getIpAddr(), dn.getIpcPort());
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Test
    public void testNamenodeProtocol() throws IOException {
        NamenodeProtocol np = (NamenodeProtocol)NameNodeProxies.createNonHAProxy((Configuration)conf, (InetSocketAddress)nnAddress, NamenodeProtocol.class, (UserGroupInformation)UserGroupInformation.getCurrentUser(), (boolean)true).getProxy();
        boolean exists = RpcClientUtil.isMethodSupported((Object)np, NamenodeProtocolPB.class, (RPC.RpcKind)RPC.RpcKind.RPC_PROTOCOL_BUFFER, (long)RPC.getProtocolVersion(NamenodeProtocolPB.class), (String)"rollEditLog");
        Assert.assertTrue((boolean)exists);
        exists = RpcClientUtil.isMethodSupported((Object)np, NamenodeProtocolPB.class, (RPC.RpcKind)RPC.RpcKind.RPC_PROTOCOL_BUFFER, (long)RPC.getProtocolVersion(NamenodeProtocolPB.class), (String)"bogusMethod");
        Assert.assertFalse((boolean)exists);
    }

    @Test
    public void testDatanodeProtocol() throws IOException {
        DatanodeProtocolClientSideTranslatorPB translator = new DatanodeProtocolClientSideTranslatorPB(nnAddress, (Configuration)conf);
        Assert.assertTrue((boolean)translator.isMethodSupported("sendHeartbeat"));
    }

    @Test
    public void testClientDatanodeProtocol() throws IOException {
        ClientDatanodeProtocolTranslatorPB translator = new ClientDatanodeProtocolTranslatorPB(nnAddress, UserGroupInformation.getCurrentUser(), (Configuration)conf, NetUtils.getDefaultSocketFactory((Configuration)conf));
        Assert.assertFalse((boolean)translator.isMethodSupported("refreshNamenodes"));
        translator = new ClientDatanodeProtocolTranslatorPB(dnAddress, UserGroupInformation.getCurrentUser(), (Configuration)conf, NetUtils.getDefaultSocketFactory((Configuration)conf));
        Assert.assertTrue((boolean)translator.isMethodSupported("refreshNamenodes"));
    }

    @Test
    public void testClientNamenodeProtocol() throws IOException {
        ClientProtocol cp = (ClientProtocol)NameNodeProxies.createNonHAProxy((Configuration)conf, (InetSocketAddress)nnAddress, ClientProtocol.class, (UserGroupInformation)UserGroupInformation.getCurrentUser(), (boolean)true).getProxy();
        RpcClientUtil.isMethodSupported((Object)cp, ClientNamenodeProtocolPB.class, (RPC.RpcKind)RPC.RpcKind.RPC_PROTOCOL_BUFFER, (long)RPC.getProtocolVersion(ClientNamenodeProtocolPB.class), (String)"mkdirs");
    }

    @Test
    public void tesJournalProtocol() throws IOException {
        JournalProtocolTranslatorPB translator = (JournalProtocolTranslatorPB)NameNodeProxies.createNonHAProxy((Configuration)conf, (InetSocketAddress)nnAddress, JournalProtocol.class, (UserGroupInformation)UserGroupInformation.getCurrentUser(), (boolean)true).getProxy();
        Assert.assertFalse((boolean)translator.isMethodSupported("startLogSegment"));
    }

    @Test
    public void testInterDatanodeProtocol() throws IOException {
        InterDatanodeProtocolTranslatorPB translator = new InterDatanodeProtocolTranslatorPB(nnAddress, UserGroupInformation.getCurrentUser(), (Configuration)conf, NetUtils.getDefaultSocketFactory((Configuration)conf), 0);
        Assert.assertFalse((boolean)translator.isMethodSupported("initReplicaRecovery"));
        translator = new InterDatanodeProtocolTranslatorPB(dnAddress, UserGroupInformation.getCurrentUser(), (Configuration)conf, NetUtils.getDefaultSocketFactory((Configuration)conf), 0);
        Assert.assertTrue((boolean)translator.isMethodSupported("initReplicaRecovery"));
    }

    @Test
    public void testGetUserMappingsProtocol() throws IOException {
        GetUserMappingsProtocolClientSideTranslatorPB translator = (GetUserMappingsProtocolClientSideTranslatorPB)NameNodeProxies.createNonHAProxy((Configuration)conf, (InetSocketAddress)nnAddress, GetUserMappingsProtocol.class, (UserGroupInformation)UserGroupInformation.getCurrentUser(), (boolean)true).getProxy();
        Assert.assertTrue((boolean)translator.isMethodSupported("getGroupsForUser"));
    }

    @Test
    public void testRefreshAuthorizationPolicyProtocol() throws IOException {
        RefreshAuthorizationPolicyProtocolClientSideTranslatorPB translator = (RefreshAuthorizationPolicyProtocolClientSideTranslatorPB)NameNodeProxies.createNonHAProxy((Configuration)conf, (InetSocketAddress)nnAddress, RefreshAuthorizationPolicyProtocol.class, (UserGroupInformation)UserGroupInformation.getCurrentUser(), (boolean)true).getProxy();
        Assert.assertTrue((boolean)translator.isMethodSupported("refreshServiceAcl"));
    }

    @Test
    public void testRefreshUserMappingsProtocol() throws IOException {
        RefreshUserMappingsProtocolClientSideTranslatorPB translator = (RefreshUserMappingsProtocolClientSideTranslatorPB)NameNodeProxies.createNonHAProxy((Configuration)conf, (InetSocketAddress)nnAddress, RefreshUserMappingsProtocol.class, (UserGroupInformation)UserGroupInformation.getCurrentUser(), (boolean)true).getProxy();
        Assert.assertTrue((boolean)translator.isMethodSupported("refreshUserToGroupsMappings"));
    }

    @Test
    public void testRefreshCallQueueProtocol() throws IOException {
        RefreshCallQueueProtocolClientSideTranslatorPB translator = (RefreshCallQueueProtocolClientSideTranslatorPB)NameNodeProxies.createNonHAProxy((Configuration)conf, (InetSocketAddress)nnAddress, RefreshCallQueueProtocol.class, (UserGroupInformation)UserGroupInformation.getCurrentUser(), (boolean)true).getProxy();
        Assert.assertTrue((boolean)translator.isMethodSupported("refreshCallQueue"));
    }
}

