/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.util.concurrent;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import org.apache.geode.CancelCriterion;
import org.apache.geode.internal.Assert;

public class StoppableCondition
implements Serializable {
    private static final long serialVersionUID = -7091681525970431937L;
    private final Condition condition;
    private final CancelCriterion stopper;
    public static final long TIME_TO_WAIT = 15000L;

    StoppableCondition(Condition c, CancelCriterion stopper) {
        Assert.assertTrue(stopper != null);
        this.condition = c;
        this.stopper = stopper;
    }

    public boolean await(long timeoutMs) throws InterruptedException {
        this.stopper.checkCancelInProgress(null);
        return this.condition.await(timeoutMs, TimeUnit.MILLISECONDS);
    }

    public synchronized void signal() {
        this.condition.signal();
    }

    public synchronized void signalAll() {
        this.condition.signalAll();
    }
}

