/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.eviction;

import java.util.Optional;
import org.apache.geode.internal.cache.eviction.EvictionController;
import org.apache.geode.internal.cache.eviction.EvictionList;
import org.apache.geode.internal.cache.eviction.LIFOList;
import org.apache.geode.internal.cache.eviction.LRUListWithAsyncSorting;
import org.apache.geode.internal.cache.eviction.LRUListWithSyncSorting;
import org.apache.geode.internal.lang.SystemProperty;

public class EvictionListBuilder {
    private final boolean evictionScanAsync;
    private final EvictionController controller;

    public EvictionListBuilder(EvictionController evictionController) {
        this.controller = evictionController;
        Optional asyncScan = SystemProperty.getProductBooleanProperty((String)"EvictionScanAsync");
        this.evictionScanAsync = asyncScan.orElse(true);
    }

    public EvictionList create() {
        if (this.controller.getEvictionAlgorithm().isLIFO()) {
            return new LIFOList(this.controller);
        }
        if (this.evictionScanAsync) {
            return new LRUListWithAsyncSorting(this.controller);
        }
        return new LRUListWithSyncSorting(this.controller);
    }
}

