/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.InputTypeStrategies;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.StateTypeStrategy;
import org.apache.flink.table.types.inference.StaticArgument;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class TypeInference {
    static final Predicate<String> PARAMETER_NAME_FORMAT = Pattern.compile("^[a-zA-Z_$][a-zA-Z_$0-9]*$").asPredicate();
    @Nullable
    private final List<StaticArgument> staticArguments;
    private final InputTypeStrategy inputTypeStrategy;
    private final LinkedHashMap<String, StateTypeStrategy> stateTypeStrategies;
    private final TypeStrategy outputTypeStrategy;

    private TypeInference(@Nullable List<StaticArgument> staticArguments, InputTypeStrategy inputTypeStrategy, LinkedHashMap<String, StateTypeStrategy> stateTypeStrategies, TypeStrategy outputTypeStrategy) {
        this.staticArguments = staticArguments;
        this.inputTypeStrategy = inputTypeStrategy;
        this.stateTypeStrategies = stateTypeStrategies;
        this.outputTypeStrategy = outputTypeStrategy;
        this.checkStateEntries();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Optional<List<StaticArgument>> getStaticArguments() {
        return Optional.ofNullable(this.staticArguments);
    }

    public InputTypeStrategy getInputTypeStrategy() {
        return this.inputTypeStrategy;
    }

    public LinkedHashMap<String, StateTypeStrategy> getStateTypeStrategies() {
        return this.stateTypeStrategies;
    }

    public TypeStrategy getOutputTypeStrategy() {
        return this.outputTypeStrategy;
    }

    @Deprecated
    public Optional<List<String>> getNamedArguments() {
        return Optional.ofNullable(this.staticArguments).map(args -> args.stream().map(StaticArgument::getName).collect(Collectors.toList()));
    }

    @Deprecated
    public Optional<List<DataType>> getTypedArguments() {
        return Optional.ofNullable(this.staticArguments).map(args -> args.stream().map(arg -> arg.getDataType().orElseThrow(() -> new IllegalArgumentException("Scalar argument with a data type expected."))).collect(Collectors.toList()));
    }

    @Deprecated
    public Optional<List<Boolean>> getOptionalArguments() {
        return Optional.ofNullable(this.staticArguments).map(args -> args.stream().map(StaticArgument::isOptional).collect(Collectors.toList()));
    }

    @Deprecated
    public Optional<TypeStrategy> getAccumulatorTypeStrategy() {
        if (this.stateTypeStrategies.isEmpty()) {
            return Optional.empty();
        }
        if (this.stateTypeStrategies.size() != 1) {
            throw new IllegalArgumentException("An accumulator should contain exactly one state type strategy.");
        }
        return Optional.of((TypeStrategy)this.stateTypeStrategies.values().iterator().next());
    }

    private void checkStateEntries() {
        List invalidStateEntries = this.stateTypeStrategies.keySet().stream().filter(n -> !PARAMETER_NAME_FORMAT.test((String)n)).collect(Collectors.toList());
        if (!invalidStateEntries.isEmpty()) {
            throw new ValidationException("Invalid state names. A state entry must follow the pattern [a-zA-Z_$][a-zA-Z_$0-9]*. But found: " + String.valueOf(invalidStateEntries));
        }
    }

    @PublicEvolving
    public static class Builder {
        @Nullable
        private List<StaticArgument> staticArguments;
        private InputTypeStrategy inputTypeStrategy = InputTypeStrategies.WILDCARD;
        private LinkedHashMap<String, StateTypeStrategy> stateTypeStrategies = new LinkedHashMap();
        @Nullable
        private TypeStrategy outputTypeStrategy;
        @Nullable
        private List<String> namedArguments;
        @Nullable
        private List<Boolean> optionalArguments;
        @Nullable
        private List<DataType> typedArguments;

        public Builder staticArguments(StaticArgument ... staticArguments) {
            this.staticArguments = Arrays.asList(staticArguments);
            return this;
        }

        public Builder staticArguments(List<StaticArgument> staticArgument) {
            this.staticArguments = staticArgument;
            return this;
        }

        public Builder inputTypeStrategy(InputTypeStrategy inputTypeStrategy) {
            this.inputTypeStrategy = (InputTypeStrategy)Preconditions.checkNotNull((Object)inputTypeStrategy, (String)"Input type strategy must not be null.");
            return this;
        }

        public Builder accumulatorTypeStrategy(TypeStrategy accumulatorTypeStrategy) {
            Preconditions.checkNotNull((Object)accumulatorTypeStrategy, (String)"Accumulator type strategy must not be null.");
            this.stateTypeStrategies.put("acc", StateTypeStrategy.of(accumulatorTypeStrategy));
            return this;
        }

        public Builder stateTypeStrategies(LinkedHashMap<String, StateTypeStrategy> stateTypeStrategies) {
            this.stateTypeStrategies = stateTypeStrategies;
            return this;
        }

        public Builder outputTypeStrategy(TypeStrategy outputTypeStrategy) {
            this.outputTypeStrategy = (TypeStrategy)Preconditions.checkNotNull((Object)outputTypeStrategy, (String)"Output type strategy must not be null.");
            return this;
        }

        public TypeInference build() {
            return new TypeInference(this.createStaticArguments(), this.inputTypeStrategy, this.stateTypeStrategies, (TypeStrategy)Preconditions.checkNotNull((Object)this.outputTypeStrategy, (String)"Output type strategy must not be null."));
        }

        @Deprecated
        public Builder namedArguments(List<String> argumentNames) {
            this.namedArguments = (List)Preconditions.checkNotNull(argumentNames, (String)"List of argument names must not be null.");
            return this;
        }

        @Deprecated
        public Builder namedArguments(String ... argumentNames) {
            return this.namedArguments(Arrays.asList(argumentNames));
        }

        @Deprecated
        public Builder optionalArguments(List<Boolean> optionalArguments) {
            this.optionalArguments = (List)Preconditions.checkNotNull(optionalArguments, (String)"List of argument optionals must not be null.");
            return this;
        }

        @Deprecated
        public Builder typedArguments(List<DataType> argumentTypes) {
            this.typedArguments = (List)Preconditions.checkNotNull(argumentTypes, (String)"List of argument types must not be null.");
            return this;
        }

        @Deprecated
        public Builder typedArguments(DataType ... argumentTypes) {
            return this.typedArguments(Arrays.asList(argumentTypes));
        }

        @Nullable
        private List<StaticArgument> createStaticArguments() {
            if (this.staticArguments != null) {
                return this.staticArguments;
            }
            if (this.typedArguments != null) {
                if (this.namedArguments != null && this.namedArguments.size() != this.typedArguments.size()) {
                    throw new IllegalArgumentException(String.format("Mismatch between typed arguments %d and named arguments %d.", this.typedArguments.size(), this.namedArguments.size()));
                }
                if (this.optionalArguments != null && this.optionalArguments.size() != this.typedArguments.size()) {
                    throw new IllegalArgumentException(String.format("Mismatch between typed arguments %d and optional arguments %d.", this.typedArguments.size(), this.optionalArguments.size()));
                }
                return IntStream.range(0, this.typedArguments.size()).mapToObj(pos -> StaticArgument.scalar(Optional.ofNullable(this.namedArguments).map(args -> (String)args.get(pos)).orElse("arg" + pos), this.typedArguments.get(pos), Optional.ofNullable(this.optionalArguments).map(args -> (Boolean)args.get(pos)).orElse(false))).collect(Collectors.toList());
            }
            return null;
        }
    }
}

