/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.auth.delegation;

import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.auth.delegation.DelegationOperations;
import org.apache.hadoop.fs.s3a.impl.StoreContext;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;

public abstract class AbstractDTService
extends AbstractService {
    private URI canonicalUri;
    private UserGroupInformation owner;
    private StoreContext storeContext;
    private DelegationOperations policyProvider;

    protected AbstractDTService(String name) {
        super(name);
    }

    public void bindToFileSystem(URI uri, StoreContext context, DelegationOperations delegationOperations) throws IOException {
        this.requireServiceState(Service.STATE.NOTINITED);
        Preconditions.checkState(this.canonicalUri == null, "bindToFileSystem called twice");
        this.canonicalUri = Objects.requireNonNull(uri);
        this.storeContext = Objects.requireNonNull(context);
        this.owner = context.getOwner();
        this.policyProvider = delegationOperations;
    }

    public URI getCanonicalUri() {
        return this.canonicalUri;
    }

    public UserGroupInformation getOwner() {
        return this.owner;
    }

    protected StoreContext getStoreContext() {
        return this.storeContext;
    }

    protected DelegationOperations getPolicyProvider() {
        return this.policyProvider;
    }

    protected void requireServiceState(Service.STATE state) throws IllegalStateException {
        Preconditions.checkState(this.isInState(state), "Required State: %s; Actual State %s", (Object)state, (Object)this.getServiceState());
    }

    protected void requireServiceStarted() throws IllegalStateException {
        this.requireServiceState(Service.STATE.STARTED);
    }

    @Override
    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        Objects.requireNonNull(this.canonicalUri, "service does not have a canonical URI");
    }
}

