/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.cloud.storage.BaseStorageWriteChannel;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.BlobWriteSessionConfig;
import com.google.cloud.storage.BufferedWritableByteChannelSession;
import com.google.cloud.storage.Conversions;
import com.google.cloud.storage.CrossTransportUtils;
import com.google.cloud.storage.GrpcBlobWriteChannel;
import com.google.cloud.storage.GrpcStorageImpl;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.StorageInternal;
import com.google.cloud.storage.StorageWriteChannel;
import com.google.cloud.storage.UnifiedOpts;
import com.google.cloud.storage.WritableByteChannelSession;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.storage.v2.WriteObjectResponse;
import java.nio.channels.WritableByteChannel;
import java.time.Clock;
import javax.annotation.concurrent.Immutable;

@BetaApi
@Immutable
public final class DefaultBlobWriteSessionConfig
extends BlobWriteSessionConfig {
    private static final long serialVersionUID = -6873740918589930633L;
    private final int chunkSize;

    @InternalApi
    DefaultBlobWriteSessionConfig(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    @BetaApi
    public DefaultBlobWriteSessionConfig withChunkSize(int chunkSize) {
        Preconditions.checkArgument(chunkSize >= 262144, "chunkSize must be >= %d", 262144);
        return new DefaultBlobWriteSessionConfig(chunkSize);
    }

    @Override
    @InternalApi
    BlobWriteSessionConfig.WriterFactory createFactory(Clock clock) {
        return new Factory(this.chunkSize);
    }

    @InternalApi
    private static final class Factory
    implements BlobWriteSessionConfig.WriterFactory {
        private final int chunkSize;

        private Factory(int chunkSize) {
            this.chunkSize = chunkSize;
        }

        @Override
        @InternalApi
        public WritableByteChannelSession<?, BlobInfo> writeSession(StorageInternal s2, BlobInfo info, UnifiedOpts.Opts<UnifiedOpts.ObjectTargetOpt> opts, Conversions.Decoder<WriteObjectResponse, BlobInfo> d) {
            if (s2 instanceof GrpcStorageImpl) {
                GrpcStorageImpl g2 = (GrpcStorageImpl)s2;
                StorageWriteChannel writer = g2.internalWriter(info, (UnifiedOpts.Opts)opts);
                ((BaseStorageWriteChannel)writer).setChunkSize(this.chunkSize);
                BufferedWritableByteChannelSession<WriteObjectResponse> session = ((GrpcBlobWriteChannel)writer).newLazyWriteChannel().getSession();
                return new DecoratedWritableByteChannelSession(session, d);
            }
            return (WritableByteChannelSession)CrossTransportUtils.throwGrpcOnly(DefaultBlobWriteSessionConfig.class, "");
        }
    }

    private static final class DecoratedWritableByteChannelSession<WBC extends WritableByteChannel, T>
    implements WritableByteChannelSession<WBC, BlobInfo> {
        private final WritableByteChannelSession<WBC, T> delegate;
        private final Conversions.Decoder<T, BlobInfo> decoder;

        private DecoratedWritableByteChannelSession(WritableByteChannelSession<WBC, T> delegate, Conversions.Decoder<T, BlobInfo> decoder) {
            this.delegate = delegate;
            this.decoder = decoder;
        }

        @Override
        public WBC open() {
            try {
                return WritableByteChannelSession.super.open();
            }
            catch (Exception e) {
                throw StorageException.coalesce(e);
            }
        }

        @Override
        public ApiFuture<WBC> openAsync() {
            return this.delegate.openAsync();
        }

        @Override
        public ApiFuture<BlobInfo> getResult() {
            return ApiFutures.transform(this.delegate.getResult(), this.decoder::decode, MoreExecutors.directExecutor());
        }
    }
}

