/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.batch;

import java.io.IOException;
import java.util.List;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.adaptive.AdaptiveJoinOperatorGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.SingleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.spec.JoinSpec;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.plan.utils.JoinUtil;
import org.apache.flink.table.planner.plan.utils.OperatorType;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.runtime.operators.join.adaptive.AdaptiveJoin;
import org.apache.flink.table.runtime.operators.join.adaptive.AdaptiveJoinOperatorFactory;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.InstantiationUtil;

public class BatchExecAdaptiveJoin
extends ExecNodeBase<RowData>
implements BatchExecNode<RowData>,
SingleTransformationTranslator<RowData> {
    private final JoinSpec joinSpec;
    private final boolean leftIsBuild;
    private final int estimatedLeftAvgRowSize;
    private final int estimatedRightAvgRowSize;
    private final long estimatedLeftRowCount;
    private final long estimatedRightRowCount;
    private final boolean tryDistinctBuildRow;
    private final String description;
    private final OperatorType originalJoin;

    public BatchExecAdaptiveJoin(ReadableConfig tableConfig, JoinSpec joinSpec, int estimatedLeftAvgRowSize, int estimatedRightAvgRowSize, long estimatedLeftRowCount, long estimatedRightRowCount, boolean leftIsBuild, boolean tryDistinctBuildRow, List<InputProperty> inputProperties, RowType outputType, String description, OperatorType originalJoin) {
        super(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(BatchExecAdaptiveJoin.class), ExecNodeContext.newPersistedConfig(BatchExecAdaptiveJoin.class, tableConfig), inputProperties, (LogicalType)outputType, description);
        this.joinSpec = joinSpec;
        this.estimatedLeftAvgRowSize = estimatedLeftAvgRowSize;
        this.estimatedRightAvgRowSize = estimatedRightAvgRowSize;
        this.estimatedLeftRowCount = estimatedLeftRowCount;
        this.estimatedRightRowCount = estimatedRightRowCount;
        this.leftIsBuild = leftIsBuild;
        this.tryDistinctBuildRow = tryDistinctBuildRow;
        this.description = description;
        this.originalJoin = originalJoin;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        ExecEdge leftInputEdge = this.getInputEdges().get(0);
        ExecEdge rightInputEdge = this.getInputEdges().get(1);
        Transformation<?> leftInputTransform = leftInputEdge.translateToPlan(planner);
        Transformation<?> rightInputTransform = rightInputEdge.translateToPlan(planner);
        RowType leftType = (RowType)leftInputEdge.getOutputType();
        RowType rightType = (RowType)rightInputEdge.getOutputType();
        long managedMemory = JoinUtil.getManagedMemory(this.joinSpec.getJoinType(), config);
        GeneratedJoinCondition condFunc = JoinUtil.generateConditionFunction((ReadableConfig)config, planner.getFlinkContext().getClassLoader(), this.joinSpec.getNonEquiCondition().orElse(null), (LogicalType)leftType, (LogicalType)rightType);
        AdaptiveJoinOperatorGenerator adaptiveJoin = new AdaptiveJoinOperatorGenerator(this.joinSpec.getLeftKeys(), this.joinSpec.getRightKeys(), this.joinSpec.getJoinType(), this.joinSpec.getFilterNulls(), leftType, rightType, condFunc, this.estimatedLeftAvgRowSize, this.estimatedRightAvgRowSize, this.estimatedLeftRowCount, this.estimatedRightRowCount, this.tryDistinctBuildRow, managedMemory, this.leftIsBuild, this.originalJoin);
        return ExecNodeUtil.createTwoInputTransformation(leftInputTransform, rightInputTransform, this.createTransformationName(config), this.createTransformationDescription(config), this.getAdaptiveJoinOperatorFactory(adaptiveJoin), InternalTypeInfo.of((LogicalType)this.getOutputType()), Math.max(leftInputTransform.getParallelism(), rightInputTransform.getParallelism()), managedMemory, false);
    }

    private StreamOperatorFactory<RowData> getAdaptiveJoinOperatorFactory(AdaptiveJoin adaptiveJoin) {
        try {
            byte[] adaptiveJoinSerialized = InstantiationUtil.serializeObject((Object)adaptiveJoin);
            return new AdaptiveJoinOperatorFactory(adaptiveJoinSerialized);
        }
        catch (IOException e) {
            throw new TableException("The adaptive join operator failed to serialize.", (Throwable)e);
        }
    }

    @Override
    public String getDescription() {
        return "AdaptiveJoin(originalJoin=[" + String.valueOf((Object)this.originalJoin) + "], " + this.description.substring(this.description.indexOf(40) + 1);
    }
}

