/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.casting;

import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.planner.codegen.calls.BuiltInMethods;
import org.apache.flink.table.planner.functions.casting.AbstractExpressionCodeGeneratorCastRule;
import org.apache.flink.table.planner.functions.casting.CastRulePredicate;
import org.apache.flink.table.planner.functions.casting.CastRuleUtils;
import org.apache.flink.table.planner.functions.casting.CodeGeneratorCastRule;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;

class NumericPrimitiveToDecimalCastRule
extends AbstractExpressionCodeGeneratorCastRule<Number, DecimalData> {
    static final NumericPrimitiveToDecimalCastRule INSTANCE = new NumericPrimitiveToDecimalCastRule();

    private NumericPrimitiveToDecimalCastRule() {
        super(CastRulePredicate.builder().input(LogicalTypeFamily.INTEGER_NUMERIC).input(LogicalTypeFamily.APPROXIMATE_NUMERIC).target(LogicalTypeRoot.DECIMAL).build());
    }

    @Override
    public String generateExpression(CodeGeneratorCastRule.Context context, String inputTerm, LogicalType inputLogicalType, LogicalType targetLogicalType) {
        DecimalType targetDecimalType = (DecimalType)targetLogicalType;
        if (inputLogicalType.is(LogicalTypeFamily.INTEGER_NUMERIC)) {
            return CastRuleUtils.staticCall(BuiltInMethods.INTEGRAL_TO_DECIMAL(), CastRuleUtils.cast("long", inputTerm), targetDecimalType.getPrecision(), targetDecimalType.getScale());
        }
        return CastRuleUtils.staticCall(BuiltInMethods.DOUBLE_TO_DECIMAL(), CastRuleUtils.cast("double", inputTerm), targetDecimalType.getPrecision(), targetDecimalType.getScale());
    }
}

