/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.math.BigDecimal;
import java.util.List;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalCalc;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalRank;
import org.apache.flink.table.planner.plan.rules.logical.ImmutableConstantRankNumberColumnRemoveRule;
import org.apache.flink.table.runtime.operators.rank.ConstantRankRange;
import org.apache.flink.table.runtime.operators.rank.RankRange;
import org.apache.flink.table.runtime.operators.rank.RankType;
import org.immutables.value.Value;

@Value.Enclosing
public class ConstantRankNumberColumnRemoveRule
extends RelRule<ConstantRankNumberColumnRemoveRuleConfig> {
    public static final ConstantRankNumberColumnRemoveRule INSTANCE = ConstantRankNumberColumnRemoveRuleConfig.DEFAULT.toRule();

    public ConstantRankNumberColumnRemoveRule(ConstantRankNumberColumnRemoveRuleConfig config) {
        super(config);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        FlinkLogicalRank rank = (FlinkLogicalRank)call.rel(0);
        boolean isRowNumber = rank.rankType() == RankType.ROW_NUMBER;
        boolean constantRowNumber = false;
        RankRange range = rank.rankRange();
        if (range instanceof ConstantRankRange) {
            constantRowNumber = ((ConstantRankRange)range).getRankStart() == ((ConstantRankRange)range).getRankEnd();
        }
        return isRowNumber && constantRowNumber && rank.outputRankNumber();
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        FlinkLogicalRank rank = (FlinkLogicalRank)call.rel(0);
        long rowNumber = ((ConstantRankRange)rank.rankRange()).getRankStart();
        FlinkLogicalRank newRank = new FlinkLogicalRank(rank.getCluster(), rank.getTraitSet(), rank.getInput(), rank.partitionKey(), rank.orderKey(), rank.rankType(), rank.rankRange(), rank.rankNumberType(), false);
        RexBuilder rexBuilder = rank.getCluster().getRexBuilder();
        RexProgramBuilder programBuilder = new RexProgramBuilder(newRank.getRowType(), rexBuilder);
        int fieldCount = rank.getRowType().getFieldCount();
        List<String> fieldNames = rank.getRowType().getFieldNames();
        for (int i = 0; i < fieldCount; ++i) {
            if (i < fieldCount - 1) {
                programBuilder.addProject(i, i, fieldNames.get(i));
                continue;
            }
            RexLiteral rowNumberLiteral = rexBuilder.makeBigintLiteral(BigDecimal.valueOf(rowNumber));
            programBuilder.addProject(i, rowNumberLiteral, fieldNames.get(i));
        }
        RexProgram rexProgram = programBuilder.getProgram();
        FlinkLogicalCalc calc = FlinkLogicalCalc.create(newRank, rexProgram);
        call.transformTo(calc);
    }

    @Value.Immutable(singleton=false)
    public static interface ConstantRankNumberColumnRemoveRuleConfig
    extends RelRule.Config {
        public static final ConstantRankNumberColumnRemoveRuleConfig DEFAULT = ImmutableConstantRankNumberColumnRemoveRule.ConstantRankNumberColumnRemoveRuleConfig.builder().operandSupplier(b0 -> b0.operand(FlinkLogicalRank.class).anyInputs()).description("ConstantRankNumberColumnRemoveRule").build();

        @Override
        default public ConstantRankNumberColumnRemoveRule toRule() {
            return new ConstantRankNumberColumnRemoveRule(this);
        }
    }
}

