/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.avatica.util.Spaces;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;

public class JsonBuilder {
    private static final ImmutableList<String> ESCAPED = ImmutableList.of("\\u0000", "\\u0001", "\\u0002", "\\u0003", "\\u0004", "\\u0005", "\\u0006", "\\u0007", "\\u0008", "\\t", "\\n", "\\u000B", new String[]{"\\f", "\\r", "\\u000E", "\\u000F", "\\u0010", "\\u0011", "\\u0012", "\\u0013", "\\u0014", "\\u0015", "\\u0016", "\\u0017", "\\u0018", "\\u0019", "\\u001A", "\\u001B", "\\u001C", "\\u001D", "\\u001E", "\\u001F"});

    public Map<String, @Nullable Object> map() {
        return new LinkedHashMap<String, Object>();
    }

    public List<@Nullable Object> list() {
        return new ArrayList<Object>();
    }

    public JsonBuilder put(Map<String, @Nullable Object> map, String name, @Nullable Object value) {
        map.put(name, value);
        return this;
    }

    public JsonBuilder putIf(Map<String, @Nullable Object> map, String name, @Nullable Object value) {
        if (value != null) {
            map.put(name, value);
        }
        return this;
    }

    public String toJsonString(Object o) {
        StringBuilder buf = new StringBuilder();
        this.append(buf, 0, o);
        return buf.toString();
    }

    public void append(StringBuilder buf, int indent, @Nullable Object o) {
        if (o == null) {
            buf.append("null");
        } else if (o instanceof Map) {
            this.appendMap(buf, indent, (Map)o);
        } else if (o instanceof List) {
            this.appendList(buf, indent, (List)o);
        } else if (o instanceof String) {
            JsonBuilder.appendString(buf, (String)o);
        } else {
            assert (o instanceof Number || o instanceof Boolean);
            buf.append(o);
        }
    }

    private static void appendString(StringBuilder buf, String s2) {
        buf.append('\"');
        int n = s2.length();
        for (int i = 0; i < n; ++i) {
            char c = s2.charAt(i);
            if (c < ' ') {
                buf.append((String)ESCAPED.get(c));
                continue;
            }
            if (c == '\\') {
                buf.append("\\\\");
                continue;
            }
            if (c == '\"') {
                buf.append("\\\"");
                continue;
            }
            buf.append(c);
        }
        buf.append('\"');
    }

    private void appendMap(StringBuilder buf, int indent, Map<String, @Nullable Object> map) {
        if (map.isEmpty()) {
            buf.append("{}");
            return;
        }
        buf.append("{");
        JsonBuilder.newline(buf, indent + 1);
        int n = 0;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (n++ > 0) {
                buf.append(",");
                JsonBuilder.newline(buf, indent + 1);
            }
            this.append(buf, 0, entry.getKey());
            buf.append(": ");
            this.append(buf, indent + 1, entry.getValue());
        }
        JsonBuilder.newline(buf, indent);
        buf.append("}");
    }

    private static void newline(StringBuilder buf, int indent) {
        Spaces.append(buf.append('\n'), indent * 2);
    }

    private void appendList(StringBuilder buf, int indent, List<?> list) {
        if (list.isEmpty()) {
            buf.append("[]");
            return;
        }
        buf.append("[");
        JsonBuilder.newline(buf, indent + 1);
        int n = 0;
        for (Object o : list) {
            if (n++ > 0) {
                buf.append(",");
                JsonBuilder.newline(buf, indent + 1);
            }
            this.append(buf, indent + 1, o);
        }
        JsonBuilder.newline(buf, indent);
        buf.append("]");
    }
}

