/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rules.ImmutableSortRemoveConstantKeysRule;
import org.apache.calcite.rel.rules.SubstitutionRule;
import org.apache.calcite.rex.RexBuilder;
import org.immutables.value.Value;

@Value.Enclosing
public class SortRemoveConstantKeysRule
extends RelRule<Config>
implements SubstitutionRule {
    protected SortRemoveConstantKeysRule(Config config) {
        super(config);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        RelNode input;
        Sort sort = (Sort)call.rel(0);
        RelMetadataQuery mq = call.getMetadataQuery();
        RelOptPredicateList predicates = mq.getPulledUpPredicates(input = sort.getInput());
        if (RelOptPredicateList.isEmpty(predicates)) {
            return;
        }
        RexBuilder rexBuilder = sort.getCluster().getRexBuilder();
        List<RelFieldCollation> collationsList = sort.getCollation().getFieldCollations().stream().filter(fc -> !predicates.constantMap.containsKey(rexBuilder.makeInputRef(input, fc.getFieldIndex()))).collect(Collectors.toList());
        if (collationsList.size() == sort.collation.getFieldCollations().size()) {
            return;
        }
        if (collationsList.isEmpty() && sort.offset == null && sort.fetch == null) {
            call.transformTo(input);
            call.getPlanner().prune(sort);
            return;
        }
        Sort result = sort.copy(sort.getTraitSet(), input, RelCollations.of(collationsList));
        call.transformTo(result);
        call.getPlanner().prune(sort);
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableSortRemoveConstantKeysRule.Config.of().withOperandSupplier(b -> b.operand(Sort.class).anyInputs());

        @Override
        default public SortRemoveConstantKeysRule toRule() {
            return new SortRemoveConstantKeysRule(this);
        }
    }
}

