/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.google.output;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Iterator;
import org.apache.druid.data.input.impl.CloudObjectLocation;
import org.apache.druid.data.input.impl.prefetch.ObjectOpenFunction;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.storage.google.GoogleInputDataConfig;
import org.apache.druid.storage.google.GoogleStorage;
import org.apache.druid.storage.google.GoogleStorageObjectMetadata;
import org.apache.druid.storage.google.GoogleUtils;
import org.apache.druid.storage.google.output.GoogleInputRange;
import org.apache.druid.storage.google.output.GoogleOutputConfig;
import org.apache.druid.storage.remote.ChunkingStorageConnector;
import org.apache.druid.storage.remote.ChunkingStorageConnectorParameters;

public class GoogleStorageConnector
extends ChunkingStorageConnector<GoogleInputRange> {
    private static final String DELIM = "/";
    private static final Joiner JOINER = Joiner.on((String)"/").skipNulls();
    private static final Logger log = new Logger(GoogleStorageConnector.class);
    private final GoogleStorage storage;
    private final GoogleOutputConfig config;
    private final GoogleInputDataConfig inputDataConfig;

    public GoogleStorageConnector(GoogleOutputConfig config, GoogleStorage googleStorage, GoogleInputDataConfig inputDataConfig) {
        this.storage = googleStorage;
        this.config = config;
        this.inputDataConfig = inputDataConfig;
        Preconditions.checkNotNull((Object)config, (Object)"config is null");
        Preconditions.checkNotNull((Object)config.getTempDir(), (Object)"tempDir is null in google config");
        try {
            FileUtils.mkdirp((File)config.getTempDir());
        }
        catch (IOException e) {
            throw new RE((Throwable)e, StringUtils.format((String)"Cannot create tempDir [%s] for google storage connector", (Object[])new Object[]{config.getTempDir()}), new Object[0]);
        }
    }

    public boolean pathExists(String path) {
        return this.storage.exists(this.config.getBucket(), this.objectPath(path));
    }

    public OutputStream write(String path) {
        return this.storage.getObjectOutputStream(this.config.getBucket(), this.objectPath(path), this.config.getChunkSize().getBytesInInt());
    }

    public void deleteFile(String path) throws IOException {
        try {
            String fullPath = this.objectPath(path);
            log.debug("Deleting file at bucket [%s] and path [%s].", new Object[]{this.config.getBucket(), fullPath});
            GoogleUtils.retryGoogleCloudStorageOperation(() -> {
                this.storage.delete(this.config.getBucket(), fullPath);
                return null;
            });
        }
        catch (Exception e) {
            log.error("Failed to delete object at bucket [%s] and path [%s].", new Object[]{this.config.getBucket(), path});
            throw new IOException(e);
        }
    }

    public void deleteFiles(Iterable<String> paths) throws IOException {
        try {
            GoogleUtils.retryGoogleCloudStorageOperation(() -> {
                this.storage.batchDelete(this.config.getBucket(), Iterables.transform((Iterable)paths, this::objectPath));
                return null;
            });
        }
        catch (Exception e) {
            log.error("Failed to delete object(s) at bucket [%s].", new Object[]{this.config.getBucket()});
            throw new IOException(e);
        }
    }

    public void deleteRecursively(String path) throws IOException {
        String fullPath = this.objectPath(path);
        Iterator<GoogleStorageObjectMetadata> storageObjects = GoogleUtils.lazyFetchingStorageObjectsIterator(this.storage, (Iterator<URI>)ImmutableList.of((Object)new CloudObjectLocation(this.config.getBucket(), fullPath).toUri("gs")).iterator(), this.inputDataConfig.getMaxListingLength());
        try {
            GoogleUtils.retryGoogleCloudStorageOperation(() -> {
                this.storage.batchDelete(this.config.getBucket(), () -> Iterators.transform((Iterator)storageObjects, GoogleStorageObjectMetadata::getName));
                return null;
            });
        }
        catch (Exception e) {
            log.error("Failed to delete object(s) at bucket [%s] and prefix [%s].", new Object[]{this.config.getBucket(), fullPath});
            throw new IOException(e);
        }
    }

    public Iterator<String> listDir(String dirName) {
        String fullPath = this.objectPath(dirName);
        Iterator<GoogleStorageObjectMetadata> storageObjects = GoogleUtils.lazyFetchingStorageObjectsIterator(this.storage, (Iterator<URI>)ImmutableList.of((Object)new CloudObjectLocation(this.config.getBucket(), fullPath).toUri("gs")).iterator(), this.inputDataConfig.getMaxListingLength());
        return Iterators.transform(storageObjects, storageObject -> {
            String[] split = storageObject.getName().split(fullPath, 2);
            if (split.length > 1) {
                return split[1];
            }
            return "";
        });
    }

    public ChunkingStorageConnectorParameters<GoogleInputRange> buildInputParams(String path) throws IOException {
        long size = this.storage.size(this.config.getBucket(), this.objectPath(path));
        return this.buildInputParams(path, 0L, size);
    }

    public ChunkingStorageConnectorParameters<GoogleInputRange> buildInputParams(String path, long from, long size) {
        ChunkingStorageConnectorParameters.Builder builder = new ChunkingStorageConnectorParameters.Builder();
        builder.start(from);
        builder.end(from + size);
        builder.cloudStoragePath(this.objectPath(path));
        builder.tempDirSupplier(this.config::getTempDir);
        builder.maxRetry(this.config.getMaxRetry().intValue());
        builder.retryCondition(GoogleUtils.GOOGLE_RETRY);
        builder.objectSupplier((start, end) -> new GoogleInputRange(start, end - start, this.config.getBucket(), this.objectPath(path)));
        builder.objectOpenFunction((ObjectOpenFunction)new ObjectOpenFunction<GoogleInputRange>(){

            public InputStream open(GoogleInputRange googleInputRange) throws IOException {
                return GoogleStorageConnector.this.storage.getInputStream(googleInputRange.getBucket(), googleInputRange.getPath(), googleInputRange.getStart(), googleInputRange.getSize());
            }

            public InputStream open(GoogleInputRange googleInputRange, long offset) throws IOException {
                long rangeStart = googleInputRange.getStart() + offset;
                return GoogleStorageConnector.this.storage.getInputStream(googleInputRange.getBucket(), googleInputRange.getPath(), rangeStart, googleInputRange.getSize());
            }
        });
        return builder.build();
    }

    private String objectPath(String path) {
        return JOINER.join((Object)this.config.getPrefix(), (Object)path, new Object[0]);
    }
}

