/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.shuffle.output;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.io.CountingOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.ExecutorService;
import org.apache.commons.io.IOUtils;
import org.apache.datasketches.memory.Memory;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.allocation.ArenaMemoryAllocator;
import org.apache.druid.frame.allocation.MemoryAllocator;
import org.apache.druid.frame.channel.ByteTracker;
import org.apache.druid.frame.channel.DurableStoragePartitionedReadableFrameChannel;
import org.apache.druid.frame.channel.ReadableInputStreamFrameChannel;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.channel.WritableFrameFileChannel;
import org.apache.druid.frame.file.FrameFileFooter;
import org.apache.druid.frame.file.FrameFileWriter;
import org.apache.druid.frame.processor.OutputChannel;
import org.apache.druid.frame.processor.PartitionedOutputChannel;
import org.apache.druid.frame.util.DurableStorageUtils;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.MappedByteBufferHandler;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.msq.shuffle.output.DurableStorageOutputChannelFactory;
import org.apache.druid.storage.StorageConnector;

public class DurableStorageTaskOutputChannelFactory
extends DurableStorageOutputChannelFactory {
    public DurableStorageTaskOutputChannelFactory(String controllerTaskId, int workerNumber, int stageNumber, String taskId, int frameSize, StorageConnector storageConnector, File tmpDir) {
        super(controllerTaskId, workerNumber, stageNumber, taskId, frameSize, storageConnector, tmpDir);
    }

    @Override
    public String getSuccessFilePath() {
        return DurableStorageUtils.getWorkerOutputSuccessFilePath((String)this.controllerTaskId, (int)this.stageNumber, (int)this.workerNumber);
    }

    @Override
    protected String getFileNameWithPathForPartition(int partitionNumber) {
        return DurableStorageUtils.getPartitionOutputsFileNameWithPathForPartition((String)this.controllerTaskId, (int)this.stageNumber, (int)this.workerNumber, (String)this.taskId, (int)partitionNumber);
    }

    public OutputChannel openChannel(int partitionNumber) throws IOException {
        String fileName = this.getFileNameWithPathForPartition(partitionNumber);
        WritableFrameFileChannel writableChannel = new WritableFrameFileChannel(FrameFileWriter.open((WritableByteChannel)Channels.newChannel(this.storageConnector.write(fileName)), null, (ByteTracker)ByteTracker.unboundedTracker()));
        return OutputChannel.pair((WritableFrameChannel)writableChannel, (MemoryAllocator)ArenaMemoryAllocator.createOnHeap((int)this.frameSize), () -> {
            try {
                if (!this.storageConnector.pathExists(fileName)) {
                    throw new ISE("File does not exist : %s", new Object[]{fileName});
                }
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            try {
                return ReadableInputStreamFrameChannel.open((InputStream)this.storageConnector.read(fileName), (String)fileName, (ExecutorService)this.remoteInputStreamPool, (boolean)false);
            }
            catch (IOException e) {
                throw new UncheckedIOException(StringUtils.format((String)"Unable to read file : %s", (Object[])new Object[]{fileName}), e);
            }
        }, (int)partitionNumber);
    }

    public PartitionedOutputChannel openPartitionedChannel(String name, boolean deleteAfterRead) throws IOException {
        String fileName = DurableStorageUtils.getOutputsFileNameForPath((String)this.controllerTaskId, (int)this.stageNumber, (int)this.workerNumber, (String)this.taskId, (String)name);
        CountingOutputStream countingOutputStream = new CountingOutputStream(this.storageConnector.write(fileName));
        WritableFrameFileChannel writableChannel = new WritableFrameFileChannel(FrameFileWriter.open((WritableByteChannel)Channels.newChannel((OutputStream)countingOutputStream), (ByteBuffer)ByteBuffer.allocate(Frame.compressionBufferSize((long)this.frameSize)), (ByteTracker)ByteTracker.unboundedTracker()));
        java.util.function.Supplier<Long> channelSizeSupplier = () -> ((CountingOutputStream)countingOutputStream).getCount();
        File footerFile = new File(this.tmpDir, fileName + "_footer");
        java.util.function.Supplier<FrameFileFooter> frameFileFooterSupplier = () -> ((Supplier)Suppliers.memoize(() -> {
            try {
                byte[] trailerBytes = new byte[16];
                long channelSize = (Long)channelSizeSupplier.get();
                try (InputStream reader = this.storageConnector.readRange(fileName, channelSize - 16L, 16L);){
                    int bytesRead = reader.read(trailerBytes, 0, trailerBytes.length);
                    if (bytesRead != 16) {
                        throw new RuntimeException("Invalid frame file trailer for object : " + fileName);
                    }
                }
                Memory trailer = Memory.wrap((byte[])trailerBytes);
                int footerLength = trailer.getInt(8L);
                FileUtils.mkdirp((File)footerFile.getParentFile());
                Preconditions.checkState((boolean)footerFile.createNewFile(), (Object)"Unable to create local footer file");
                try (FileOutputStream footerFileStream = new FileOutputStream(footerFile);
                     InputStream footerInputStream = this.storageConnector.readRange(fileName, channelSize - (long)footerLength, (long)footerLength);){
                    IOUtils.copy((InputStream)footerInputStream, (OutputStream)footerFileStream);
                }
                MappedByteBufferHandler mapHandle = FileUtils.map((File)footerFile);
                Memory footerMemory = Memory.wrap((ByteBuffer)mapHandle.get(), (ByteOrder)ByteOrder.LITTLE_ENDIAN);
                return new FrameFileFooter(footerMemory, channelSize);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        })).get();
        return PartitionedOutputChannel.pair((WritableFrameChannel)writableChannel, (MemoryAllocator)ArenaMemoryAllocator.createOnHeap((int)this.frameSize), () -> new DurableStoragePartitionedReadableFrameChannel(this.storageConnector, frameFileFooterSupplier, fileName, this.remoteInputStreamPool, footerFile));
    }
}

