/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.guice;

import com.google.inject.Binder;
import com.google.inject.Provides;
import java.nio.ByteBuffer;
import org.apache.druid.collections.NonBlockingPool;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.annotations.Global;
import org.apache.druid.guice.annotations.LoadScope;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.msq.exec.MemoryIntrospector;
import org.apache.druid.msq.exec.MemoryIntrospectorImpl;
import org.apache.druid.msq.exec.ProcessingBuffersProvider;
import org.apache.druid.msq.guice.TaskMemoryManagementConfig;
import org.apache.druid.msq.indexing.PeonProcessingBuffersProvider;
import org.apache.druid.query.DruidProcessingConfig;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainerProvider;
import org.apache.druid.utils.RuntimeInfo;

@LoadScope(roles={"peon"})
public class PeonMemoryManagementModule
implements DruidModule {
    private static final int NUM_WORKERS_IN_JVM = 1;
    private static final double USABLE_MEMORY_FRACTION = 0.75;

    public void configure(Binder binder) {
        TaskMemoryManagementConfig.bind(binder);
    }

    @Provides
    @LazySingleton
    public MemoryIntrospector createMemoryIntrospector(LookupExtractorFactoryContainerProvider lookupProvider, DruidProcessingConfig processingConfig, TaskMemoryManagementConfig taskMemoryManagementConfig, RuntimeInfo runtimeInfo) {
        return new MemoryIntrospectorImpl(runtimeInfo.getMaxHeapSizeBytes(), 0.75, 1, PeonMemoryManagementModule.getNumThreads(taskMemoryManagementConfig, processingConfig), lookupProvider);
    }

    @Provides
    @LazySingleton
    public ProcessingBuffersProvider createProcessingBuffersProvider(@Global NonBlockingPool<ByteBuffer> processingPool, MemoryIntrospector memoryIntrospector) {
        return new PeonProcessingBuffersProvider(processingPool, memoryIntrospector.numProcessingThreads());
    }

    public static int getNumThreads(TaskMemoryManagementConfig taskMemoryManagementConfig, DruidProcessingConfig processingConfig) {
        if (taskMemoryManagementConfig.getMaxThreads() == -1) {
            return processingConfig.getNumThreads();
        }
        if (taskMemoryManagementConfig.getMaxThreads() > 0) {
            return Math.min(taskMemoryManagementConfig.getMaxThreads(), processingConfig.getNumThreads());
        }
        throw new IAE("Invalid value of %s.maxThreads[%d]", new Object[]{TaskMemoryManagementConfig.BASE_PROPERTY, taskMemoryManagementConfig.getMaxThreads()});
    }
}

