/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.exec;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.storage.ExportStorageProvider;
import org.apache.druid.storage.StorageConnector;

public class ExportMetadataManager {
    public static final String SYMLINK_DIR = "_symlink_format_manifest";
    public static final String MANIFEST_FILE = "_symlink_format_manifest/manifest";
    public static final String META_FILE = "_symlink_format_manifest/druid_export_meta";
    public static final int MANIFEST_FILE_VERSION = 1;
    private static final Logger log = new Logger(ExportMetadataManager.class);
    private final ExportStorageProvider exportStorageProvider;
    private final File tmpDir;

    public ExportMetadataManager(ExportStorageProvider exportStorageProvider, File tmpDir) {
        this.exportStorageProvider = exportStorageProvider;
        this.tmpDir = tmpDir;
    }

    public void writeMetadata(List<String> exportedFiles) throws IOException {
        StorageConnector storageConnector = this.exportStorageProvider.createStorageConnector(this.tmpDir);
        log.info("Writing manifest file at location [%s]", new Object[]{this.exportStorageProvider.getBasePath()});
        if (storageConnector.pathExists(MANIFEST_FILE) || storageConnector.pathExists(META_FILE)) {
            throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.USER).ofCategory(DruidException.Category.RUNTIME_FAILURE).build("Found existing manifest file already present at path.", new Object[0]);
        }
        this.createManifestFile(storageConnector, exportedFiles);
        this.createDruidMetadataFile(storageConnector);
    }

    public void createManifestFile(StorageConnector storageConnector, List<String> exportedFiles) throws IOException {
        try (PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(storageConnector.write(MANIFEST_FILE), StandardCharsets.UTF_8));){
            for (String exportedFile : exportedFiles) {
                printWriter.println(this.exportStorageProvider.getFilePathForManifest(exportedFile));
            }
        }
    }

    private void createDruidMetadataFile(StorageConnector storageConnector) throws IOException {
        try (PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(storageConnector.write(META_FILE), StandardCharsets.UTF_8));){
            printWriter.println(StringUtils.format((String)"version: %s", (Object[])new Object[]{1}));
        }
    }
}

