/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.storage.sql;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.apache.druid.catalog.CatalogException;
import org.apache.druid.catalog.model.ColumnSpec;
import org.apache.druid.catalog.model.TableId;
import org.apache.druid.catalog.model.TableMetadata;
import org.apache.druid.catalog.model.TableSpec;
import org.apache.druid.catalog.storage.MetadataStorageManager;
import org.apache.druid.catalog.storage.sql.CatalogManager;
import org.apache.druid.catalog.storage.sql.DbUtils;
import org.apache.druid.catalog.sync.CatalogUpdateListener;
import org.apache.druid.catalog.sync.UpdateEvent;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.ResultIterator;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.exceptions.CallbackFailedException;
import org.skife.jdbi.v2.exceptions.UnableToExecuteStatementException;
import org.skife.jdbi.v2.tweak.HandleCallback;

@ManageLifecycle
public class SQLCatalogManager
implements CatalogManager {
    public static final String TABLES_TABLE = "tableDefs";
    private static final String SCHEMA_NAME_COL = "schemaName";
    private static final String TABLE_NAME_COL = "name";
    private static final String CREATION_TIME_COL = "creationTime";
    private static final String UPDATE_TIME_COL = "updateTime";
    private static final String STATE_COL = "state";
    private static final String TABLE_TYPE_COL = "tableType";
    private static final String PROPERTIES_COL = "properties";
    private static final String COLUMNS_COL = "columns";
    private final MetadataStorageManager metastoreManager;
    private final SQLMetadataConnector connector;
    private final ObjectMapper jsonMapper;
    private final IDBI dbi;
    private final String tableName;
    private final Deque<CatalogUpdateListener> listeners = new ConcurrentLinkedDeque<CatalogUpdateListener>();
    public static final String CREATE_TABLE = "CREATE TABLE %s (\n  schemaName VARCHAR(255) NOT NULL,\n  name VARCHAR(255) NOT NULL,\n  creationTime BIGINT NOT NULL,\n  updateTime BIGINT NOT NULL,\n  state CHAR(1) NOT NULL,\n  tableType VARCHAR(20) NOT NULL,\n  properties %s,\n  columns %s,\n  PRIMARY KEY(schemaName, name)\n)";
    private static final String INSERT_TABLE = "INSERT INTO %s\n  (schemaName, name, creationTime, updateTime, state,\n   tableType, properties, columns)\n  VALUES(:schemaName, :name, :creationTime, :updateTime, :state,\n         :tableType, :properties, :columns)";
    private static final String SELECT_TABLE = "SELECT creationTime, updateTime, state, tableType, properties, columns\nFROM %s\nWHERE schemaName = :schemaName\n  AND name = :name\n";
    private static final String REPLACE_SPEC_STMT = "UPDATE %s\n SET\n  tableType = :tableType,\n  properties = :properties,\n  columns = :columns,\n  updateTime = :updateTime\nWHERE schemaName = :schemaName\n  AND name = :name\n  AND state = 'A'";
    private static final String OLD_VERSION_PARAM = "oldVersion";
    private static final String UPDATE_SPEC_STMT = "UPDATE %s\n SET\n  tableType = :tableType,\n  properties = :properties,\n  columns = :columns,\n  updateTime = :updateTime\nWHERE schemaName = :schemaName\n  AND name = :name\n  AND state = 'A'  AND updateTime = :oldVersion";
    private static final String SELECT_PROPERTIES_STMT = "SELECT tableType, properties\nFROM %s\nWHERE schemaName = :schemaName\n  AND name = :name\n  AND state = 'A'";
    private static final String UPDATE_PROPERTIES_STMT = "UPDATE %s\n SET\n  properties = :properties,\n  updateTime = :updateTime\nWHERE schemaName = :schemaName\n  AND name = :name\n";
    private static final String SELECT_COLUMNS_STMT = "SELECT tableType, columns\nFROM %s\nWHERE schemaName = :schemaName\n  AND name = :name\n  AND state = 'A'";
    private static final String UPDATE_COLUMNS_STMT = "UPDATE %s\n SET\n  columns = :columns,\n  updateTime = :updateTime\nWHERE schemaName = :schemaName\n  AND name = :name\n";
    private static final String MARK_DELETING_STMT = "UPDATE %s\n SET\n  state = 'D',\n  updateTime = :updateTime\nWHERE schemaName = :schemaName\n  AND name = :name\n";
    private static final String DELETE_TABLE_STMT = "DELETE FROM %s\nWHERE schemaName = :schemaName\n  AND name = :name\n";
    private static final String SELECT_ALL_TABLE_PATHS_STMT = "SELECT schemaName, name\nFROM %s\nORDER BY schemaName, name";
    private static final String SELECT_TABLE_NAMES_IN_SCHEMA_STMT = "SELECT name\nFROM %s\nWHERE schemaName = :schemaName\nORDER BY name";
    private static final String SELECT_TABLES_IN_SCHEMA_STMT = "SELECT name, creationTime, updateTime, state, tableType, properties, columns\nFROM %s\nWHERE schemaName = :schemaName\nORDER BY name";
    private static final TypeReference<Map<String, Object>> PROPERTIES_TYPE_REF = new TypeReference<Map<String, Object>>(){};
    private static final TypeReference<List<ColumnSpec>> COLUMNS_TYPE_REF = new TypeReference<List<ColumnSpec>>(){};

    @Inject
    public SQLCatalogManager(MetadataStorageManager metastoreManager) {
        if (!metastoreManager.isSql()) {
            throw new ISE("SQLCatalogManager only works with SQL based metadata store at this time", new Object[0]);
        }
        this.metastoreManager = metastoreManager;
        this.connector = metastoreManager.sqlConnector();
        this.dbi = this.connector.getDBI();
        this.jsonMapper = metastoreManager.jsonMapper();
        this.tableName = this.getTableDefnTable();
    }

    @Override
    @LifecycleStart
    public void start() {
        this.createTableDefnTable();
    }

    public void createTableDefnTable() {
        if (!this.metastoreManager.config().isCreateTables()) {
            return;
        }
        this.connector.createTable(this.tableName, (Iterable)ImmutableList.of((Object)StringUtils.format((String)CREATE_TABLE, (Object[])new Object[]{this.tableName, this.connector.getPayloadType(), this.connector.getPayloadType()})));
    }

    @Override
    public long create(final TableMetadata table) throws CatalogException.DuplicateKeyException {
        try {
            return (Long)this.dbi.withHandle((HandleCallback)new HandleCallback<Long>(){

                public Long withHandle(Handle handle) throws CatalogException.DuplicateKeyException {
                    TableSpec spec = table.spec();
                    long updateTime = System.currentTimeMillis();
                    Update stmt = (Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)handle.createStatement(SQLCatalogManager.this.statement(SQLCatalogManager.INSERT_TABLE)).bind(SQLCatalogManager.SCHEMA_NAME_COL, table.id().schema())).bind(SQLCatalogManager.TABLE_NAME_COL, table.id().name())).bind(SQLCatalogManager.CREATION_TIME_COL, updateTime)).bind(SQLCatalogManager.UPDATE_TIME_COL, updateTime)).bind(SQLCatalogManager.STATE_COL, TableMetadata.TableState.ACTIVE.code())).bind(SQLCatalogManager.TABLE_TYPE_COL, spec.type())).bind(SQLCatalogManager.PROPERTIES_COL, JacksonUtils.toBytes((ObjectMapper)SQLCatalogManager.this.jsonMapper, (Object)spec.properties()))).bind(SQLCatalogManager.COLUMNS_COL, JacksonUtils.toBytes((ObjectMapper)SQLCatalogManager.this.jsonMapper, (Object)spec.columns()));
                    try {
                        stmt.execute();
                    }
                    catch (UnableToExecuteStatementException e) {
                        if (DbUtils.isDuplicateRecordException(e)) {
                            throw new CatalogException.DuplicateKeyException("Tried to insert a duplicate table: %s", table.sqlName());
                        }
                        throw e;
                    }
                    SQLCatalogManager.this.sendAddition(table, updateTime);
                    return updateTime;
                }
            });
        }
        catch (CallbackFailedException e) {
            if (e.getCause() instanceof CatalogException.DuplicateKeyException) {
                throw (CatalogException.DuplicateKeyException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public TableMetadata read(final TableId id) throws CatalogException.NotFoundException {
        try {
            return (TableMetadata)this.dbi.withHandle((HandleCallback)new HandleCallback<TableMetadata>(){

                public TableMetadata withHandle(Handle handle) throws CatalogException.NotFoundException {
                    Query query = (Query)((Query)handle.createQuery(SQLCatalogManager.this.statement(SQLCatalogManager.SELECT_TABLE)).setFetchSize(SQLCatalogManager.this.connector.getStreamingFetchSize()).bind(SQLCatalogManager.SCHEMA_NAME_COL, id.schema())).bind(SQLCatalogManager.TABLE_NAME_COL, id.name());
                    ResultIterator resultIterator = query.map((index, r, ctx) -> new TableMetadata(id, r.getLong(1), r.getLong(2), TableMetadata.TableState.fromCode((String)r.getString(3)), SQLCatalogManager.tableSpecFromBytes(SQLCatalogManager.this.jsonMapper, r.getString(4), r.getBytes(5), r.getBytes(6)))).iterator();
                    if (resultIterator.hasNext()) {
                        return (TableMetadata)resultIterator.next();
                    }
                    throw SQLCatalogManager.this.tableNotFound(id);
                }
            });
        }
        catch (CallbackFailedException e) {
            if (e.getCause() instanceof CatalogException.NotFoundException) {
                throw (CatalogException.NotFoundException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public long replace(final TableMetadata table) throws CatalogException.NotFoundException {
        try {
            TableMetadata revised = (TableMetadata)this.dbi.withHandle((HandleCallback)new HandleCallback<TableMetadata>(){

                public TableMetadata withHandle(Handle handle) throws CatalogException.NotFoundException {
                    TableId id = table.id();
                    TableSpec spec = table.spec();
                    long updateTime = System.currentTimeMillis();
                    int updateCount = ((Update)((Update)((Update)((Update)((Update)((Update)handle.createStatement(SQLCatalogManager.this.statement(SQLCatalogManager.REPLACE_SPEC_STMT)).bind(SQLCatalogManager.SCHEMA_NAME_COL, id.schema())).bind(SQLCatalogManager.TABLE_NAME_COL, id.name())).bind(SQLCatalogManager.TABLE_TYPE_COL, spec.type())).bind(SQLCatalogManager.PROPERTIES_COL, JacksonUtils.toBytes((ObjectMapper)SQLCatalogManager.this.jsonMapper, (Object)spec.properties()))).bind(SQLCatalogManager.COLUMNS_COL, JacksonUtils.toBytes((ObjectMapper)SQLCatalogManager.this.jsonMapper, (Object)spec.columns()))).bind(SQLCatalogManager.UPDATE_TIME_COL, updateTime)).execute();
                    if (updateCount == 0) {
                        throw SQLCatalogManager.this.tableNotFound(id);
                    }
                    return table.asUpdate(updateTime);
                }
            });
            this.sendUpdate(UpdateEvent.EventType.UPDATE, revised);
            return revised.updateTime();
        }
        catch (CallbackFailedException e) {
            if (e.getCause() instanceof CatalogException.NotFoundException) {
                throw (CatalogException.NotFoundException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public long update(final TableMetadata table, final long oldVersion) throws CatalogException.NotFoundException {
        try {
            TableMetadata revised = (TableMetadata)this.dbi.withHandle((HandleCallback)new HandleCallback<TableMetadata>(){

                public TableMetadata withHandle(Handle handle) throws CatalogException.NotFoundException {
                    TableId id = table.id();
                    TableSpec spec = table.spec();
                    long updateTime = System.currentTimeMillis();
                    int updateCount = ((Update)((Update)((Update)((Update)((Update)((Update)((Update)handle.createStatement(SQLCatalogManager.this.statement(SQLCatalogManager.UPDATE_SPEC_STMT)).bind(SQLCatalogManager.SCHEMA_NAME_COL, id.schema())).bind(SQLCatalogManager.TABLE_NAME_COL, id.name())).bind(SQLCatalogManager.TABLE_TYPE_COL, spec.type())).bind(SQLCatalogManager.PROPERTIES_COL, JacksonUtils.toBytes((ObjectMapper)SQLCatalogManager.this.jsonMapper, (Object)spec.properties()))).bind(SQLCatalogManager.COLUMNS_COL, JacksonUtils.toBytes((ObjectMapper)SQLCatalogManager.this.jsonMapper, (Object)spec.columns()))).bind(SQLCatalogManager.UPDATE_TIME_COL, updateTime)).bind(SQLCatalogManager.OLD_VERSION_PARAM, oldVersion)).execute();
                    if (updateCount == 0) {
                        throw new CatalogException.NotFoundException("Table %s: not found, is being deleted or update version does not match DB version", id.sqlName());
                    }
                    return table.asUpdate(updateTime);
                }
            });
            this.sendUpdate(UpdateEvent.EventType.UPDATE, revised);
            return revised.updateTime();
        }
        catch (CallbackFailedException e) {
            if (e.getCause() instanceof CatalogException.NotFoundException) {
                throw (CatalogException.NotFoundException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public long updateProperties(final TableId id, final CatalogManager.TableTransform transform) throws CatalogException {
        try {
            TableMetadata result = (TableMetadata)this.dbi.withHandle((HandleCallback)new HandleCallback<TableMetadata>(){

                public TableMetadata withHandle(Handle handle) throws CatalogException {
                    handle.begin();
                    try {
                        Query query = (Query)((Query)handle.createQuery(SQLCatalogManager.this.statement(SQLCatalogManager.SELECT_PROPERTIES_STMT)).setFetchSize(SQLCatalogManager.this.connector.getStreamingFetchSize()).bind(SQLCatalogManager.SCHEMA_NAME_COL, id.schema())).bind(SQLCatalogManager.TABLE_NAME_COL, id.name());
                        ResultIterator resultIterator = query.map((index, r, ctx) -> SQLCatalogManager.tableSpecFromBytes(SQLCatalogManager.this.jsonMapper, r.getString(1), r.getBytes(2), null)).iterator();
                        if (!resultIterator.hasNext()) {
                            throw SQLCatalogManager.this.tableNotFound(id);
                        }
                        TableSpec tableSpec = (TableSpec)resultIterator.next();
                        TableSpec revised = transform.apply(TableMetadata.of((TableId)id, (TableSpec)tableSpec));
                        if (revised == null) {
                            handle.rollback();
                            return null;
                        }
                        long updateTime = System.currentTimeMillis();
                        int updateCount = ((Update)((Update)((Update)((Update)handle.createStatement(SQLCatalogManager.this.statement(SQLCatalogManager.UPDATE_PROPERTIES_STMT)).bind(SQLCatalogManager.SCHEMA_NAME_COL, id.schema())).bind(SQLCatalogManager.TABLE_NAME_COL, id.name())).bind(SQLCatalogManager.PROPERTIES_COL, JacksonUtils.toBytes((ObjectMapper)SQLCatalogManager.this.jsonMapper, (Object)revised.properties()))).bind(SQLCatalogManager.UPDATE_TIME_COL, updateTime)).execute();
                        if (updateCount == 0) {
                            throw new ISE("Table %s: not found", new Object[]{id.sqlName()});
                        }
                        handle.commit();
                        return TableMetadata.forUpdate((TableId)id, (long)updateTime, (TableSpec)revised);
                    }
                    catch (Exception e) {
                        handle.rollback();
                        throw e;
                    }
                }
            });
            if (result == null) {
                return 0L;
            }
            this.sendUpdate(UpdateEvent.EventType.PROPERTY_UPDATE, result);
            return result.updateTime();
        }
        catch (CallbackFailedException e) {
            if (e.getCause() instanceof CatalogException) {
                throw (CatalogException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public long updateColumns(final TableId id, final CatalogManager.TableTransform transform) throws CatalogException {
        try {
            TableMetadata result = (TableMetadata)this.dbi.withHandle((HandleCallback)new HandleCallback<TableMetadata>(){

                public TableMetadata withHandle(Handle handle) throws CatalogException {
                    handle.begin();
                    try {
                        Query query = (Query)((Query)handle.createQuery(SQLCatalogManager.this.statement(SQLCatalogManager.SELECT_COLUMNS_STMT)).setFetchSize(SQLCatalogManager.this.connector.getStreamingFetchSize()).bind(SQLCatalogManager.SCHEMA_NAME_COL, id.schema())).bind(SQLCatalogManager.TABLE_NAME_COL, id.name());
                        ResultIterator resultIterator = query.map((index, r, ctx) -> SQLCatalogManager.tableSpecFromBytes(SQLCatalogManager.this.jsonMapper, r.getString(1), null, r.getBytes(2))).iterator();
                        if (!resultIterator.hasNext()) {
                            throw SQLCatalogManager.this.tableNotFound(id);
                        }
                        TableSpec tableSpec = (TableSpec)resultIterator.next();
                        TableSpec revised = transform.apply(TableMetadata.of((TableId)id, (TableSpec)tableSpec));
                        if (revised == null) {
                            handle.rollback();
                            return null;
                        }
                        long updateTime = System.currentTimeMillis();
                        int updateCount = ((Update)((Update)((Update)((Update)handle.createStatement(SQLCatalogManager.this.statement(SQLCatalogManager.UPDATE_COLUMNS_STMT)).bind(SQLCatalogManager.SCHEMA_NAME_COL, id.schema())).bind(SQLCatalogManager.TABLE_NAME_COL, id.name())).bind(SQLCatalogManager.COLUMNS_COL, JacksonUtils.toBytes((ObjectMapper)SQLCatalogManager.this.jsonMapper, (Object)revised.columns()))).bind(SQLCatalogManager.UPDATE_TIME_COL, updateTime)).execute();
                        if (updateCount == 0) {
                            throw new ISE("Table %s: not found", new Object[]{id.sqlName()});
                        }
                        handle.commit();
                        return TableMetadata.forUpdate((TableId)id, (long)updateTime, (TableSpec)revised);
                    }
                    catch (Exception e) {
                        handle.rollback();
                        throw e;
                    }
                }
            });
            if (result == null) {
                return 0L;
            }
            this.sendUpdate(UpdateEvent.EventType.COLUMNS_UPDATE, result);
            return result.updateTime();
        }
        catch (CallbackFailedException e) {
            if (e.getCause() instanceof CatalogException) {
                throw (CatalogException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public long markDeleting(final TableId id) {
        return (Long)this.dbi.withHandle((HandleCallback)new HandleCallback<Long>(){

            public Long withHandle(Handle handle) {
                long updateTime = System.currentTimeMillis();
                int updateCount = ((Update)((Update)((Update)handle.createStatement(SQLCatalogManager.this.statement(SQLCatalogManager.MARK_DELETING_STMT)).bind(SQLCatalogManager.SCHEMA_NAME_COL, id.schema())).bind(SQLCatalogManager.TABLE_NAME_COL, id.name())).bind(SQLCatalogManager.UPDATE_TIME_COL, updateTime)).execute();
                SQLCatalogManager.this.sendDeletion(id);
                return updateCount == 1 ? updateTime : 0L;
            }
        });
    }

    @Override
    public void delete(final TableId id) throws CatalogException.NotFoundException {
        try {
            this.dbi.withHandle((HandleCallback)new HandleCallback<Void>(){

                public Void withHandle(Handle handle) throws CatalogException.NotFoundException {
                    int updateCount = ((Update)((Update)handle.createStatement(SQLCatalogManager.this.statement(SQLCatalogManager.DELETE_TABLE_STMT)).bind(SQLCatalogManager.SCHEMA_NAME_COL, id.schema())).bind(SQLCatalogManager.TABLE_NAME_COL, id.name())).execute();
                    if (updateCount == 0) {
                        throw SQLCatalogManager.this.tableNotFound(id);
                    }
                    SQLCatalogManager.this.sendDeletion(id);
                    return null;
                }
            });
        }
        catch (CallbackFailedException e) {
            if (e.getCause() instanceof CatalogException.NotFoundException) {
                throw (CatalogException.NotFoundException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public List<TableId> allTablePaths() {
        return (List)this.dbi.withHandle((HandleCallback)new HandleCallback<List<TableId>>(){

            public List<TableId> withHandle(Handle handle) {
                Query query = handle.createQuery(SQLCatalogManager.this.statement(SQLCatalogManager.SELECT_ALL_TABLE_PATHS_STMT)).setFetchSize(SQLCatalogManager.this.connector.getStreamingFetchSize());
                ResultIterator resultIterator = query.map((index, r, ctx) -> new TableId(r.getString(1), r.getString(2))).iterator();
                return Lists.newArrayList((Iterator)resultIterator);
            }
        });
    }

    @Override
    public List<String> tableNamesInSchema(final String dbSchema) {
        return (List)this.dbi.withHandle((HandleCallback)new HandleCallback<List<String>>(){

            public List<String> withHandle(Handle handle) {
                Query query = ((Query)handle.createQuery(SQLCatalogManager.this.statement(SQLCatalogManager.SELECT_TABLE_NAMES_IN_SCHEMA_STMT)).bind(SQLCatalogManager.SCHEMA_NAME_COL, dbSchema)).setFetchSize(SQLCatalogManager.this.connector.getStreamingFetchSize());
                ResultIterator resultIterator = query.map((index, r, ctx) -> r.getString(1)).iterator();
                return Lists.newArrayList((Iterator)resultIterator);
            }
        });
    }

    @Override
    public List<TableMetadata> tablesInSchema(final String dbSchema) {
        return (List)this.dbi.withHandle((HandleCallback)new HandleCallback<List<TableMetadata>>(){

            public List<TableMetadata> withHandle(Handle handle) {
                Query query = ((Query)handle.createQuery(SQLCatalogManager.this.statement(SQLCatalogManager.SELECT_TABLES_IN_SCHEMA_STMT)).bind(SQLCatalogManager.SCHEMA_NAME_COL, dbSchema)).setFetchSize(SQLCatalogManager.this.connector.getStreamingFetchSize());
                ResultIterator resultIterator = query.map((index, r, ctx) -> new TableMetadata(TableId.of((String)dbSchema, (String)r.getString(1)), r.getLong(2), r.getLong(3), TableMetadata.TableState.fromCode((String)r.getString(4)), SQLCatalogManager.tableSpecFromBytes(SQLCatalogManager.this.jsonMapper, r.getString(5), r.getBytes(6), r.getBytes(7)))).iterator();
                return Lists.newArrayList((Iterator)resultIterator);
            }
        });
    }

    @Override
    public synchronized void register(CatalogUpdateListener listener) {
        this.listeners.add(listener);
    }

    protected synchronized void sendAddition(TableMetadata table, long updateTime) {
        if (this.listeners.isEmpty()) {
            return;
        }
        this.sendEvent(new UpdateEvent(UpdateEvent.EventType.CREATE, table.fromInsert(updateTime)));
    }

    protected synchronized void sendUpdate(UpdateEvent.EventType eventType, TableMetadata table) {
        if (this.listeners.isEmpty()) {
            return;
        }
        this.sendEvent(new UpdateEvent(eventType, table));
    }

    protected void sendDeletion(TableId id) {
        this.sendEvent(new UpdateEvent(UpdateEvent.EventType.DELETE, TableMetadata.empty((TableId)id)));
    }

    protected synchronized void sendEvent(UpdateEvent event) {
        for (CatalogUpdateListener listener : this.listeners) {
            listener.updated(event);
        }
    }

    public String getTableDefnTable() {
        String base = this.metastoreManager.tablesConfig().getBase();
        if (Strings.isNullOrEmpty((String)base)) {
            return TABLES_TABLE;
        }
        return StringUtils.format((String)"%s_%s", (Object[])new Object[]{base, TABLES_TABLE});
    }

    private String statement(String baseStmt) {
        return StringUtils.format((String)baseStmt, (Object[])new Object[]{this.tableName});
    }

    private CatalogException.NotFoundException tableNotFound(TableId id) {
        return new CatalogException.NotFoundException("Table %s: not found", id.sqlName());
    }

    private static <T> T fromBytes(ObjectMapper jsonMapper, byte[] bytes, TypeReference<T> typeRef) {
        try {
            return (T)jsonMapper.readValue(bytes, typeRef);
        }
        catch (IOException e) {
            throw new ISE((Throwable)e, "Failed to deserialize a DB object", new Object[0]);
        }
    }

    private static TableSpec tableSpecFromBytes(ObjectMapper jsonMapper, String type, byte[] properties, byte[] columns) {
        return new TableSpec(type, properties == null ? null : SQLCatalogManager.propertiesFromBytes(jsonMapper, properties), columns == null ? null : SQLCatalogManager.columnsFromBytes(jsonMapper, columns));
    }

    private static Map<String, Object> propertiesFromBytes(ObjectMapper jsonMapper, byte[] properties) {
        return SQLCatalogManager.fromBytes(jsonMapper, properties, PROPERTIES_TYPE_REF);
    }

    private static List<ColumnSpec> columnsFromBytes(ObjectMapper jsonMapper, byte[] properties) {
        return SQLCatalogManager.fromBytes(jsonMapper, properties, COLUMNS_TYPE_REF);
    }
}

