/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.avro;

import com.google.common.collect.ImmutableMap;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericEnumSymbol;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.util.Utf8;
import org.apache.druid.java.util.common.parsers.FlattenerJsonProvider;

public class GenericAvroJsonProvider
extends FlattenerJsonProvider {
    private final boolean extractUnionsByType;

    GenericAvroJsonProvider(boolean extractUnionsByType) {
        this.extractUnionsByType = extractUnionsByType;
    }

    public boolean isArray(Object o) {
        return o instanceof List;
    }

    public int length(Object o) {
        if (o instanceof List) {
            return ((List)o).size();
        }
        if (o instanceof GenericRecord) {
            return ((GenericRecord)o).getSchema().getFields().size();
        }
        return 0;
    }

    public Collection<String> getPropertyKeys(Object o) {
        if (o == null) {
            return Collections.emptySet();
        }
        if (o instanceof Map) {
            return ((Map)o).keySet().stream().map(String::valueOf).collect(Collectors.toSet());
        }
        if (o instanceof GenericRecord) {
            return ((GenericRecord)o).getSchema().getFields().stream().map(Schema.Field::name).collect(Collectors.toSet());
        }
        throw new UnsupportedOperationException("Unused");
    }

    @Nullable
    public Object getMapValue(Object o, String s) {
        if (o == null) {
            return null;
        }
        if (o instanceof GenericRecord) {
            GenericRecord record = (GenericRecord)o;
            if (this.extractUnionsByType && this.isExtractableUnion(record.getSchema().getField(s))) {
                return this.extractUnionTypes(record.get(s));
            }
            return record.get(s);
        }
        if (o instanceof Map) {
            Map theMap = (Map)o;
            if (theMap.containsKey(s)) {
                return theMap.get(s);
            }
            Utf8 utf8Key = new Utf8(s);
            return theMap.get(utf8Key);
        }
        throw new UnsupportedOperationException(o.getClass().getName());
    }

    public void setProperty(Object o, Object o1, Object o2) {
        if (o instanceof Map) {
            ((Map)o).put(o1, o2);
        } else if (o instanceof GenericRecord) {
            ((GenericRecord)o).put(String.valueOf(o1), o2);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public boolean isMap(Object o) {
        return o == null || o instanceof Map || o instanceof GenericRecord;
    }

    private boolean isExtractableUnion(Schema.Field field) {
        return field.schema().isUnion() && field.schema().getTypes().stream().filter(type -> type.getType() != Schema.Type.NULL).count() > 1L;
    }

    private Map<String, Object> extractUnionTypes(Object o) {
        if (o instanceof Integer) {
            return ImmutableMap.of((Object)"int", (Object)o);
        }
        if (o instanceof Long) {
            return ImmutableMap.of((Object)"long", (Object)o);
        }
        if (o instanceof Float) {
            return ImmutableMap.of((Object)"float", (Object)o);
        }
        if (o instanceof Double) {
            return ImmutableMap.of((Object)"double", (Object)o);
        }
        if (o instanceof Boolean) {
            return ImmutableMap.of((Object)"boolean", (Object)o);
        }
        if (o instanceof Utf8) {
            return ImmutableMap.of((Object)"string", (Object)o);
        }
        if (o instanceof ByteBuffer) {
            return ImmutableMap.of((Object)"bytes", (Object)o);
        }
        if (o instanceof Map) {
            return ImmutableMap.of((Object)"map", (Object)o);
        }
        if (o instanceof List) {
            return ImmutableMap.of((Object)"array", (Object)o);
        }
        if (o instanceof GenericRecord) {
            return ImmutableMap.of((Object)((GenericRecord)o).getSchema().getName(), (Object)o);
        }
        if (o instanceof GenericFixed) {
            return ImmutableMap.of((Object)((GenericFixed)o).getSchema().getName(), (Object)o);
        }
        if (o instanceof GenericEnumSymbol) {
            return ImmutableMap.of((Object)((GenericEnumSymbol)o).getSchema().getName(), (Object)o);
        }
        return ImmutableMap.of();
    }

    public Object unwrap(Object o) {
        if (o instanceof Utf8) {
            return o.toString();
        }
        return o;
    }
}

