/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.google;

import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.gax.paging.Page;
import com.google.cloud.ReadChannel;
import com.google.cloud.WriteChannel;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Storage;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.apache.druid.java.util.common.IOE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.storage.google.GoogleStorageObjectMetadata;
import org.apache.druid.storage.google.GoogleStorageObjectPage;

public class GoogleStorage {
    private static final Logger log = new Logger(GoogleStorage.class);
    private static final HumanReadableBytes DEFAULT_WRITE_CHUNK_SIZE = new HumanReadableBytes("4MiB");
    private final Supplier<Storage> storage;

    public GoogleStorage(Supplier<Storage> storage) {
        this.storage = storage;
    }

    public void insert(String bucket, String path, AbstractInputStreamContent mediaContent, @Nullable Integer bufferSize) throws IOException {
        if (bufferSize == null) {
            ((Storage)this.storage.get()).createFrom(this.getBlobInfo(bucket, path), mediaContent.getInputStream(), new Storage.BlobWriteOption[0]);
        } else {
            ((Storage)this.storage.get()).createFrom(this.getBlobInfo(bucket, path), mediaContent.getInputStream(), bufferSize.intValue(), new Storage.BlobWriteOption[0]);
        }
    }

    public InputStream getInputStream(String bucket, String path) throws IOException {
        return this.getInputStream(bucket, path, 0L, null, null);
    }

    public InputStream getInputStream(String bucket, String path, long start) throws IOException {
        return this.getInputStream(bucket, path, start, null, null);
    }

    public InputStream getInputStream(String bucket, String path, long start, Long length) throws IOException {
        return this.getInputStream(bucket, path, start, length, null);
    }

    public InputStream getInputStream(String bucket, String path, long start, @Nullable Long length, @Nullable Integer chunkSize) throws IOException {
        ReadChannel reader = ((Storage)this.storage.get()).reader(bucket, path, new Storage.BlobSourceOption[0]);
        reader.seek(start);
        if (length != null) {
            reader.limit(start + length);
        }
        if (chunkSize != null) {
            reader.setChunkSize(chunkSize.intValue());
        }
        return Channels.newInputStream((ReadableByteChannel)reader);
    }

    public OutputStream getObjectOutputStream(String bucket, String path, @Nullable Integer chunkSize) {
        WriteChannel writer = ((Storage)this.storage.get()).writer(this.getBlobInfo(bucket, path), new Storage.BlobWriteOption[0]);
        writer.setChunkSize(chunkSize == null ? DEFAULT_WRITE_CHUNK_SIZE.getBytesInInt() : chunkSize.intValue());
        return Channels.newOutputStream((WritableByteChannel)writer);
    }

    public GoogleStorageObjectMetadata getMetadata(String bucket, String path) throws IOException {
        Blob blob = ((Storage)this.storage.get()).get(bucket, path, new Storage.BlobGetOption[]{Storage.BlobGetOption.fields((Storage.BlobField[])Storage.BlobField.values())});
        if (blob == null) {
            throw new IOE("Failed to fetch google cloud storage object from bucket [%s] and path[%s].", new Object[]{bucket, path});
        }
        return new GoogleStorageObjectMetadata(blob.getBucket(), blob.getName(), blob.getSize(), blob.getUpdateTimeOffsetDateTime().toEpochSecond() * 1000L);
    }

    public void delete(String bucket, String path) {
        if (!((Storage)this.storage.get()).delete(bucket, path, new Storage.BlobSourceOption[0])) {
            log.debug("Google cloud storage object to be deleted not found in bucket [%s] and path [%s].", new Object[]{bucket, path});
        }
    }

    public void batchDelete(String bucket, Iterable<String> paths) {
        List statuses = ((Storage)this.storage.get()).delete(Iterables.transform(paths, input -> BlobId.of((String)bucket, (String)input)));
        if (statuses.contains(false)) {
            log.debug("Google cloud storage object(s) to be deleted not found in bucket [%s].", new Object[]{bucket});
        }
    }

    public boolean exists(String bucket, String path) {
        Blob blob = ((Storage)this.storage.get()).get(bucket, path, new Storage.BlobGetOption[0]);
        return blob != null;
    }

    public long size(String bucket, String path) throws IOException {
        Blob blob = ((Storage)this.storage.get()).get(bucket, path, new Storage.BlobGetOption[]{Storage.BlobGetOption.fields((Storage.BlobField[])new Storage.BlobField[]{Storage.BlobField.SIZE})});
        if (blob == null) {
            throw new IOE("Failed to fetch google cloud storage object from bucket [%s] and path [%s].", new Object[]{bucket, path});
        }
        return blob.getSize();
    }

    public String version(String bucket, String path) throws IOException {
        Blob blob = ((Storage)this.storage.get()).get(bucket, path, new Storage.BlobGetOption[]{Storage.BlobGetOption.fields((Storage.BlobField[])new Storage.BlobField[]{Storage.BlobField.ETAG})});
        if (blob == null) {
            throw new IOE("Failed to fetch google cloud storage object from bucket [%s] and path [%s].", new Object[]{bucket, path});
        }
        return blob.getEtag();
    }

    public GoogleStorageObjectPage list(String bucket, @Nullable String prefix, @Nullable Long pageSize, @Nullable String pageToken) throws IOException {
        Page blobPage;
        ArrayList<Storage.BlobListOption> options = new ArrayList<Storage.BlobListOption>();
        if (prefix != null) {
            options.add(Storage.BlobListOption.prefix((String)prefix));
        }
        if (pageSize != null) {
            options.add(Storage.BlobListOption.pageSize((long)pageSize));
        }
        if (pageToken != null) {
            options.add(Storage.BlobListOption.pageToken((String)pageToken));
        }
        if ((blobPage = ((Storage)this.storage.get()).list(bucket, options.toArray(new Storage.BlobListOption[0]))) == null) {
            throw new IOE("Failed to fetch google cloud storage object from bucket [%s] and prefix [%s].", new Object[]{bucket, prefix});
        }
        List<GoogleStorageObjectMetadata> googleStorageObjectMetadataList = blobPage.streamValues().map(blob -> new GoogleStorageObjectMetadata(blob.getBucket(), blob.getName(), blob.getSize(), blob.getUpdateTimeOffsetDateTime().toEpochSecond() * 1000L)).collect(Collectors.toList());
        return new GoogleStorageObjectPage(googleStorageObjectMetadataList, blobPage.getNextPageToken());
    }

    private BlobInfo getBlobInfo(String bucket, String path) {
        BlobId blobId = BlobId.of((String)bucket, (String)path);
        return BlobInfo.newBuilder((BlobId)blobId).build();
    }
}

