/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.policy;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.query.policy.Policy;
import org.apache.druid.query.policy.PolicyEnforcer;

public class RestrictAllTablesPolicyEnforcer
implements PolicyEnforcer {
    private final ImmutableList<String> allowedPolicies;

    @JsonCreator
    public RestrictAllTablesPolicyEnforcer(@Nullable @JsonProperty(value="allowedPolicies") List<String> allowedPolicies) {
        this.allowedPolicies = allowedPolicies == null ? ImmutableList.of() : ImmutableList.copyOf(allowedPolicies);
    }

    @Override
    public boolean validate(Policy policy) {
        return policy != null && (this.allowedPolicies.isEmpty() || this.allowedPolicies.contains((Object)policy.getClass().getName()));
    }

    @JsonProperty
    public ImmutableList<String> getAllowedPolicies() {
        return this.allowedPolicies;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestrictAllTablesPolicyEnforcer that = (RestrictAllTablesPolicyEnforcer)o;
        return this.allowedPolicies.equals(that.allowedPolicies);
    }

    public int hashCode() {
        return Objects.hash(this.allowedPolicies);
    }

    public String toString() {
        return "RestrictAllTablesPolicyEnforcer{allowedPolicies=" + this.allowedPolicies + "}";
    }
}

