/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics;

import com.google.common.primitives.Longs;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.metrics.cgroups.CgroupDiscoverer;

public class CgroupUtil {
    private static final Logger LOG = new Logger(CgroupUtil.class);
    public static final String SPACE_MATCH = Pattern.quote(" ");
    public static final String COMMA_MATCH = Pattern.quote(",");
    public static final String TOTAL = "total";
    public static final String USER = "user";
    public static final String SYSTEM = "system";
    public static final String CPU_TOTAL_USAGE_METRIC = "cgroup/cpu/usage/total/percentage";
    public static final String CPU_USER_USAGE_METRIC = "cgroup/cpu/usage/user/percentage";
    public static final String CPU_SYS_USAGE_METRIC = "cgroup/cpu/usage/sys/percentage";
    public static final String DISK_READ_BYTES_METRIC = "cgroup/disk/read/bytes";
    public static final String DISK_READ_COUNT_METRIC = "cgroup/disk/read/count";
    public static final String DISK_WRITE_BYTES_METRIC = "cgroup/disk/write/bytes";
    public static final String DISK_WRITE_COUNT_METRIC = "cgroup/disk/write/count";

    public static long readLongValue(CgroupDiscoverer discoverer, String cgroup, String fileName, long defaultValue) {
        try {
            List<String> lines = Files.readAllLines(Paths.get(discoverer.discover(cgroup).toString(), fileName));
            return lines.stream().map(Longs::tryParse).filter(Objects::nonNull).findFirst().orElse(defaultValue);
        }
        catch (IOException | RuntimeException ex) {
            LOG.noStackTrace().warn(ex, "Unable to fetch %s", fileName);
            return defaultValue;
        }
    }
}

