/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.filtration;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.apache.druid.query.filter.AndDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.IsFalseDimFilter;
import org.apache.druid.query.filter.IsTrueDimFilter;
import org.apache.druid.query.filter.NotDimFilter;
import org.apache.druid.query.filter.OrDimFilter;
import org.apache.druid.sql.calcite.filtration.Filtration;

public abstract class BottomUpTransform
implements Function<Filtration, Filtration> {
    protected abstract DimFilter process(DimFilter var1);

    private DimFilter checkedProcess(DimFilter filter) {
        DimFilter retVal = this.process((DimFilter)Preconditions.checkNotNull((Object)filter, (Object)"filter"));
        assert (retVal != null);
        return retVal;
    }

    public Filtration apply(Filtration filtration) {
        if (filtration.getDimFilter() != null) {
            Filtration retVal = Filtration.create(this.apply0(filtration.getDimFilter()), filtration.getIntervals());
            return filtration.equals(retVal) ? retVal : this.apply(retVal);
        }
        return filtration;
    }

    private DimFilter apply0(DimFilter filter) {
        if (filter instanceof AndDimFilter) {
            List oldFilters = ((AndDimFilter)filter).getFields();
            ArrayList<DimFilter> newFilters = new ArrayList<DimFilter>();
            for (DimFilter oldFilter : oldFilters) {
                DimFilter newFilter = this.apply0(oldFilter);
                if (newFilter == null) continue;
                newFilters.add(newFilter);
            }
            if (!newFilters.equals(oldFilters)) {
                return this.checkedProcess((DimFilter)new AndDimFilter(newFilters));
            }
            return this.checkedProcess(filter);
        }
        if (filter instanceof OrDimFilter) {
            List oldFilters = ((OrDimFilter)filter).getFields();
            ArrayList<DimFilter> newFilters = new ArrayList<DimFilter>();
            for (DimFilter oldFilter : oldFilters) {
                DimFilter newFilter = this.apply0(oldFilter);
                if (newFilter == null) continue;
                newFilters.add(newFilter);
            }
            if (!newFilters.equals(oldFilters)) {
                return this.checkedProcess((DimFilter)new OrDimFilter(newFilters));
            }
            return this.checkedProcess(filter);
        }
        if (filter instanceof NotDimFilter) {
            DimFilter newFilter;
            DimFilter oldFilter = ((NotDimFilter)filter).getField();
            if (!oldFilter.equals(newFilter = this.apply0(oldFilter))) {
                return this.checkedProcess((DimFilter)new NotDimFilter(newFilter));
            }
            return this.checkedProcess(filter);
        }
        if (filter instanceof IsTrueDimFilter) {
            DimFilter newFilter;
            DimFilter oldFilter = ((IsTrueDimFilter)filter).getField();
            if (!oldFilter.equals(newFilter = this.apply0(oldFilter))) {
                return this.checkedProcess((DimFilter)new IsTrueDimFilter(newFilter));
            }
            return this.checkedProcess(filter);
        }
        if (filter instanceof IsFalseDimFilter) {
            DimFilter newFilter;
            DimFilter oldFilter = ((IsFalseDimFilter)filter).getField();
            if (!oldFilter.equals(newFilter = this.apply0(oldFilter))) {
                return this.checkedProcess((DimFilter)new IsFalseDimFilter(newFilter));
            }
            return this.checkedProcess(filter);
        }
        return this.checkedProcess(filter);
    }
}

