/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.common.server.data;

import java.util.Objects;

public class Name {
    private final String unquotedName;
    private final String maybeQuotedName;
    private final boolean isSourceQuoted;

    public Name(String maybeQuotedName) {
        Objects.requireNonNull(maybeQuotedName, "name must not be null");
        this.unquotedName = this.removeQuotesIfNecessary(maybeQuotedName);
        this.maybeQuotedName = maybeQuotedName;
        this.isSourceQuoted = !this.unquotedName.equals(maybeQuotedName);
    }

    public String name() {
        return this.unquotedName;
    }

    public String maybeQuotedName() {
        return this.maybeQuotedName;
    }

    public boolean isSourceQuoted() {
        return this.isSourceQuoted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Name name = (Name)o;
        return Objects.equals(this.unquotedName, name.unquotedName) && Objects.equals(this.maybeQuotedName, name.maybeQuotedName);
    }

    public int hashCode() {
        return Objects.hash(this.unquotedName, this.maybeQuotedName);
    }

    public String toString() {
        return "Name{unquotedName='" + this.unquotedName + "', maybeQuotedName='" + this.maybeQuotedName + "'}";
    }

    private String removeQuotesIfNecessary(String name) {
        if (name == null || name.length() <= 1 || name.charAt(0) != '\"' || name.charAt(name.length() - 1) != '\"') {
            return name;
        }
        return name.substring(1, name.length() - 1);
    }
}

