/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.utils;

import io.vertx.core.MultiMap;
import io.vertx.core.file.FileSystem;
import org.apache.cassandra.sidecar.common.request.data.XXHash32Digest;
import org.apache.cassandra.sidecar.utils.AsyncFileDigestVerifier;
import org.apache.cassandra.sidecar.utils.DigestAlgorithm;
import org.apache.cassandra.sidecar.utils.DigestAlgorithmProvider;
import org.jetbrains.annotations.NotNull;

public class XXHash32DigestVerifier
extends AsyncFileDigestVerifier<XXHash32Digest> {
    protected XXHash32DigestVerifier(@NotNull FileSystem fs, @NotNull XXHash32Digest digest, @NotNull DigestAlgorithm digestAlgorithm) {
        super(fs, digest, digestAlgorithm);
    }

    public static XXHash32DigestVerifier create(FileSystem fs, MultiMap headers, DigestAlgorithmProvider digestAlgorithmProvider) {
        XXHash32Digest digest = new XXHash32Digest(headers.get("cassandra-content-xxhash32"), headers.get("cassandra-content-xxhash32-seed"));
        DigestAlgorithm digestAlgorithm = digestAlgorithmProvider.get(XXHash32DigestVerifier.maybeGetSeedOrDefault(digest));
        return new XXHash32DigestVerifier(fs, digest, digestAlgorithm);
    }

    protected static int maybeGetSeedOrDefault(XXHash32Digest digest) {
        String seedHex = digest.seedHex();
        if (seedHex != null) {
            return (int)Long.parseLong(seedHex, 16);
        }
        return 0;
    }
}

