/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.handlers.restore;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.RoutingContext;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.cassandra.sidecar.common.data.RestoreJobStatus;
import org.apache.cassandra.sidecar.common.server.data.QualifiedTableName;
import org.apache.cassandra.sidecar.concurrent.ExecutorPools;
import org.apache.cassandra.sidecar.db.RestoreJob;
import org.apache.cassandra.sidecar.db.RestoreJobDatabaseAccessor;
import org.apache.cassandra.sidecar.routes.RoutingContextUtils;
import org.apache.cassandra.sidecar.utils.CassandraInputValidator;
import org.apache.cassandra.sidecar.utils.HttpExceptions;

@Singleton
public class RestoreRequestValidationHandler
implements Handler<RoutingContext> {
    private final CassandraInputValidator validator;
    private final RestoreJobDatabaseAccessor restoreJobs;
    private final ExecutorPools executorPools;

    @Inject
    public RestoreRequestValidationHandler(CassandraInputValidator validator, RestoreJobDatabaseAccessor restoreJobs, ExecutorPools executorPools) {
        this.validator = validator;
        this.restoreJobs = restoreJobs;
        this.executorPools = executorPools;
    }

    public void handle(RoutingContext context) {
        QualifiedTableName tableName = this.verifyQualifiedTableName(context);
        RoutingContextUtils.put(context, RoutingContextUtils.SC_QUALIFIED_TABLE_NAME, tableName);
        UUID jobId = this.verifyJobIdIfPresent(context);
        this.verifyJobStatusIfPresent(context);
        this.verifyJobExistAndStoreAsync(context, jobId, tableName).onSuccess(ignored -> context.next()).onFailure(arg_0 -> ((RoutingContext)context).fail(arg_0));
    }

    private QualifiedTableName verifyQualifiedTableName(RoutingContext context) {
        String keyspace = context.pathParam("keyspace");
        String table = context.pathParam("table");
        this.validator.validateKeyspaceName(keyspace);
        this.validator.validateTableName(table);
        return new QualifiedTableName(keyspace, table, true);
    }

    private UUID verifyJobIdIfPresent(RoutingContext context) {
        UUID jobId;
        HttpServerRequest request = context.request();
        if (request.method() == HttpMethod.POST && request.path().endsWith("/restore-jobs")) {
            return null;
        }
        String jobIdFromPath = context.pathParam("jobId");
        if (jobIdFromPath == null) {
            throw HttpExceptions.wrapHttpException(HttpResponseStatus.BAD_REQUEST, "PathParam jobId must be present for the request");
        }
        try {
            jobId = UUID.fromString(jobIdFromPath);
        }
        catch (Exception e) {
            throw HttpExceptions.wrapHttpException(HttpResponseStatus.BAD_REQUEST, "Invalid jobId - not an UUID, " + jobIdFromPath);
        }
        if (jobId.version() != 1) {
            throw HttpExceptions.wrapHttpException(HttpResponseStatus.BAD_REQUEST, "Invalid jobId - not a time-based UUID, " + jobIdFromPath);
        }
        return jobId;
    }

    private Future<Void> verifyJobExistAndStoreAsync(RoutingContext context, @Nullable UUID jobId, QualifiedTableName tableName) {
        if (jobId == null) {
            return Future.succeededFuture();
        }
        return this.findJob(jobId).compose(restoreJob -> {
            if (!tableName.keyspace().equalsIgnoreCase(restoreJob.keyspaceName) || !tableName.tableName().equalsIgnoreCase(restoreJob.tableName)) {
                return Future.failedFuture((Throwable)HttpExceptions.wrapHttpException(HttpResponseStatus.NOT_FOUND, "Restore job with jobId: " + jobId + " is not found for table: " + tableName));
            }
            RoutingContextUtils.put(context, RoutingContextUtils.SC_RESTORE_JOB, restoreJob);
            return Future.succeededFuture();
        });
    }

    private void verifyJobStatusIfPresent(RoutingContext context) {
        String status;
        String string = status = context.getBodyAsJson() == null ? null : context.getBodyAsJson().getString("status");
        if (status == null) {
            return;
        }
        try {
            RestoreJobStatus.valueOf((String)status);
        }
        catch (Exception e) {
            throw HttpExceptions.wrapHttpException(HttpResponseStatus.BAD_REQUEST, "Unrecognized restore job status passed, " + status);
        }
    }

    private Future<RestoreJob> findJob(UUID jobId) {
        return this.executorPools.service().executeBlocking(() -> {
            RestoreJob restoreJob = this.restoreJobs.find(jobId);
            if (restoreJob == null) {
                throw HttpExceptions.wrapHttpException(HttpResponseStatus.NOT_FOUND, "Restore job with id: " + jobId + " does not exist");
            }
            return restoreJob;
        });
    }
}

