/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos.uncommitted;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.statements.SelectStatement;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.ReadQuery;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.paxos.Commit;
import org.apache.cassandra.service.paxos.PaxosRepairHistory;
import org.apache.cassandra.service.paxos.uncommitted.PaxosBallotTracker;
import org.apache.cassandra.service.paxos.uncommitted.PaxosKeyState;
import org.apache.cassandra.service.paxos.uncommitted.PaxosRows;
import org.apache.cassandra.service.paxos.uncommitted.PaxosUncommittedTracker;
import org.apache.cassandra.utils.CloseableIterator;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaxosStateTracker {
    private static final Logger logger = LoggerFactory.getLogger(PaxosStateTracker.class);
    private static final String DIRECTORY = "system/_paxos_repair_state";
    private final PaxosUncommittedTracker uncommitted;
    private final PaxosBallotTracker ballots;
    private boolean rebuildNeeded;

    private static boolean skipRebuild() {
        return CassandraRelevantProperties.SKIP_PAXOS_STATE_REBUILD.getBoolean();
    }

    private static boolean forceRebuild() {
        return CassandraRelevantProperties.FORCE_PAXOS_STATE_REBUILD.getBoolean();
    }

    private static boolean truncateBallotMetadata() {
        return CassandraRelevantProperties.TRUNCATE_BALLOT_METADATA.getBoolean();
    }

    public PaxosStateTracker(PaxosUncommittedTracker uncommitted, PaxosBallotTracker ballots, boolean rebuildNeeded) {
        this.uncommitted = uncommitted;
        this.ballots = ballots;
        this.rebuildNeeded = rebuildNeeded;
    }

    public boolean isRebuildNeeded() {
        return this.rebuildNeeded;
    }

    static File stateDirectory(File dataDirectory) {
        return new File(dataDirectory, DIRECTORY);
    }

    public static PaxosStateTracker create(File[] directories) throws IOException {
        boolean rebuildNeeded;
        File stateDirectory = null;
        boolean hasExistingData = false;
        for (File directory : directories) {
            File candidate = PaxosStateTracker.stateDirectory(directory);
            if (!candidate.exists() || !new File(candidate, "ballot.meta").exists()) continue;
            Preconditions.checkState((!hasExistingData ? 1 : 0) != 0, (String)"Multiple paxos repair metadata directories found (%s, %s), remove the older directory and restart.", (Object)stateDirectory, (Object)candidate);
            hasExistingData = true;
            stateDirectory = candidate;
        }
        if (stateDirectory == null) {
            stateDirectory = PaxosStateTracker.stateDirectory(directories[0]);
        }
        boolean bl = rebuildNeeded = !hasExistingData || PaxosStateTracker.forceRebuild();
        if (PaxosStateTracker.truncateBallotMetadata() && !rebuildNeeded) {
            logger.warn("{} was set to true, but {} was not and no rebuild is required. Ballot data will not be truncated", (Object)CassandraRelevantProperties.TRUNCATE_BALLOT_METADATA.getKey(), (Object)CassandraRelevantProperties.FORCE_PAXOS_STATE_REBUILD.getKey());
        }
        if (rebuildNeeded) {
            if (stateDirectory.exists()) {
                PaxosUncommittedTracker.truncate(stateDirectory);
                if (PaxosStateTracker.truncateBallotMetadata()) {
                    PaxosBallotTracker.truncate(stateDirectory);
                }
            } else {
                stateDirectory.createDirectoriesIfNotExists();
            }
        }
        PaxosUncommittedTracker uncommitted = PaxosUncommittedTracker.load(stateDirectory);
        PaxosBallotTracker ballots = PaxosBallotTracker.load(stateDirectory);
        if (!rebuildNeeded) {
            uncommitted.start();
        }
        return new PaxosStateTracker(uncommitted, ballots, rebuildNeeded);
    }

    public static PaxosStateTracker create(Directories.DataDirectories dataDirectories) throws IOException {
        return PaxosStateTracker.create((File[])dataDirectories.getAllDirectories().stream().map(d -> d.location).toArray(File[]::new));
    }

    private void rebuildUncommittedData() throws IOException {
        logger.info("Beginning uncommitted paxos data rebuild. Set -D{}=true and restart to skip", (Object)CassandraRelevantProperties.SKIP_PAXOS_STATE_REBUILD.getKey());
        String queryStr = "SELECT * FROM system.paxos";
        SelectStatement stmt = (SelectStatement)QueryProcessor.parseStatement(queryStr).prepare(ClientState.forInternalCalls());
        ReadQuery query = stmt.getQuery(QueryOptions.DEFAULT, FBUtilities.nowInSeconds());
        try (ReadExecutionController controller = query.executionController();
             PartitionIterator partitions = query.executeInternal(controller);
             PaxosKeyStateRowsIterator rows = new PaxosKeyStateRowsIterator(partitions);){
            this.uncommitted.rebuild(rows);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void updateLowBoundFromRepairHistory() throws IOException {
        queryStr = "SELECT * FROM system.paxos_repair_history";
        stmt = (SelectStatement)QueryProcessor.parseStatement(queryStr).prepare(ClientState.forInternalCalls());
        query = stmt.getQuery(QueryOptions.DEFAULT, FBUtilities.nowInSeconds());
        lowBound = null;
        listType = ListType.getInstance(BytesType.instance, false);
        pointsColumn = ColumnMetadata.regularColumn("system", "paxos_repair_history", "points", listType);
        controller = query.executionController();
        try {
            partitions = query.executeInternal(controller);
lbl10:
            // 2 sources

            try {
                while (partitions.hasNext()) {
                    partition = (RowIterator)partitions.next();
                    try {
                        keyspaceName = (String)UTF8Type.instance.compose(partition.partitionKey().getKey());
                        if (Schema.instance.getKeyspaceMetadata(keyspaceName) == null) continue;
                        Keyspace.open(keyspaceName);
                        while (partition.hasNext()) {
                            row = (Row)partition.next();
                            clustering = row.clustering();
                            tableName = (String)UTF8Type.instance.compose(clustering.get(0), clustering.accessor());
                            if (Schema.instance.getTableMetadata(keyspaceName, tableName) == null) continue;
                            pointsCell = row.getCell(pointsColumn);
                            points = (List)listType.compose(pointsCell.value(), pointsCell.accessor());
                            history = PaxosRepairHistory.fromTupleBufferList(points);
                            lowBound = Commit.latest(lowBound, history.maxLowBound());
                        }
                    }
                    finally {
                        if (partition == null) ** GOTO lbl10
                        partition.close();
                    }
                }
            }
            finally {
                if (partitions != null) {
                    partitions.close();
                }
            }
        }
        finally {
            if (controller != null) {
                controller.close();
            }
        }
        this.ballots.updateLowBound(lowBound);
    }

    public void maybeRebuild() throws IOException {
        if (!this.rebuildNeeded) {
            return;
        }
        if (PaxosStateTracker.truncateBallotMetadata()) {
            logger.info("Truncating {}.{}", (Object)"system", (Object)"paxos_repair_history");
            Keyspace.open("system").getColumnFamilyStore("paxos_repair_history").truncateBlocking();
        }
        if (!PaxosStateTracker.skipRebuild()) {
            this.rebuildUncommittedData();
            if (!PaxosStateTracker.truncateBallotMetadata()) {
                this.updateLowBoundFromRepairHistory();
            }
            logger.info("Uncommitted paxos data rebuild completed");
        }
        this.uncommitted.start();
        this.ballots.flush();
        this.rebuildNeeded = false;
    }

    public PaxosUncommittedTracker uncommitted() {
        return this.uncommitted;
    }

    public PaxosBallotTracker ballots() {
        return this.ballots;
    }

    class PaxosKeyStateRowsIterator
    implements CloseableIterator<PaxosKeyState> {
        final PartitionIterator partitions;
        RowIterator partition = null;
        PaxosKeyState next = null;

        PaxosKeyStateRowsIterator(PartitionIterator partitions) {
            this.partitions = partitions;
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            while (true) {
                if (this.partition != null && this.partition.hasNext()) {
                    PaxosKeyState commitState = PaxosRows.getCommitState(this.partition.partitionKey(), (Row)this.partition.next(), null);
                    if (commitState == null) continue;
                    PaxosStateTracker.this.ballots.updateHighBound(commitState.ballot);
                    if (commitState.committed) continue;
                    this.next = commitState;
                    return true;
                }
                if (this.partition != null) {
                    this.partition.close();
                    this.partition = null;
                }
                if (!this.partitions.hasNext()) {
                    return false;
                }
                this.partition = (RowIterator)this.partitions.next();
            }
        }

        @Override
        public PaxosKeyState next() {
            if (this.next == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            PaxosKeyState next = this.next;
            this.next = null;
            return next;
        }

        @Override
        public void close() {
            if (this.partition != null) {
                this.partition.close();
                this.partition = null;
            }
        }
    }
}

