/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos;

import java.util.Collection;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.service.paxos.Ballot;
import org.apache.cassandra.service.paxos.PaxosRepairHistory;

public class TablePaxosRepairHistory {
    private final String keyspace;
    private final String table;
    private volatile PaxosRepairHistory history;

    private TablePaxosRepairHistory(String keyspace, String table, PaxosRepairHistory history) {
        this.keyspace = keyspace;
        this.table = table;
        this.history = history;
    }

    public static TablePaxosRepairHistory load(String keyspace, String table) {
        return new TablePaxosRepairHistory(keyspace, table, SystemKeyspace.loadPaxosRepairHistory(keyspace, table));
    }

    public Ballot getBallotForToken(Token token) {
        return this.history.ballotForToken(token);
    }

    private void updatePaxosRepairTable(PaxosRepairHistory update, boolean flush) {
        SystemKeyspace.savePaxosRepairHistory(this.keyspace, this.table, update, flush);
    }

    public synchronized void add(Collection<Range<Token>> ranges, Ballot ballot, boolean flush) {
        PaxosRepairHistory update = PaxosRepairHistory.add(this.history, ranges, ballot);
        this.updatePaxosRepairTable(update, flush);
        this.history = update;
    }

    public synchronized void merge(PaxosRepairHistory toMerge, boolean flush) {
        PaxosRepairHistory update = PaxosRepairHistory.merge(this.history, toMerge);
        if (!update.equals(this.history)) {
            this.updatePaxosRepairTable(update, flush);
        }
        this.history = update;
    }

    public PaxosRepairHistory getHistory() {
        return this.history;
    }

    public PaxosRepairHistory getHistoryForRanges(Collection<Range<Token>> ranges) {
        return PaxosRepairHistory.trim(this.history, ranges);
    }
}

