/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.exceptions;

import java.util.List;
import org.apache.cassandra.cql3.functions.OperationFcts;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.exceptions.FunctionExecutionException;

public final class OperationExecutionException
extends FunctionExecutionException {
    public static OperationExecutionException create(char operator, List<AbstractType<?>> argTypes, Exception e) {
        List<String> cqlTypes = AbstractType.asCQLTypeStringList(argTypes);
        String msg = String.format("the operation '%s %s %s' failed: %s", cqlTypes.get(0), Character.valueOf(operator), cqlTypes.get(1), e.getMessage());
        return new OperationExecutionException(operator, cqlTypes, msg);
    }

    public OperationExecutionException(char operator, List<String> argTypes, String msg) {
        super(OperationFcts.getFunctionNameFromOperator(operator), argTypes, msg);
    }
}

