/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.settings;

import com.datastax.driver.core.exceptions.AlreadyExistsException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.stress.settings.GroupedOptions;
import org.apache.cassandra.stress.settings.Option;
import org.apache.cassandra.stress.settings.OptionCompaction;
import org.apache.cassandra.stress.settings.OptionReplication;
import org.apache.cassandra.stress.settings.OptionSimple;
import org.apache.cassandra.stress.settings.SettingsCommand;
import org.apache.cassandra.stress.settings.SettingsCommandUser;
import org.apache.cassandra.stress.settings.StressSettings;
import org.apache.cassandra.stress.util.JavaDriverClient;
import org.apache.cassandra.stress.util.ResultLogger;
import org.apache.cassandra.utils.ByteBufferUtil;

public class SettingsSchema
implements Serializable {
    public static final String DEFAULT_VALIDATOR = "BytesType";
    private final String replicationStrategy;
    private final Map<String, String> replicationStrategyOptions;
    private final String compression;
    private final String compactionStrategy;
    private final Map<String, String> compactionStrategyOptions;
    public final String keyspace;

    public SettingsSchema(Options options, SettingsCommand command) {
        this.keyspace = command instanceof SettingsCommandUser ? null : options.keyspace.value();
        this.replicationStrategy = options.replication.getStrategy();
        this.replicationStrategyOptions = options.replication.getOptions();
        this.compression = options.compression.value();
        this.compactionStrategy = options.compaction.getStrategy();
        this.compactionStrategyOptions = options.compaction.getOptions();
    }

    public void createKeySpaces(StressSettings settings) {
        JavaDriverClient client = settings.getJavaDriverClient(false);
        try {
            client.execute(this.createKeyspaceStatementCQL3(), ConsistencyLevel.LOCAL_ONE);
            client.execute("USE \"" + this.keyspace + "\"", ConsistencyLevel.LOCAL_ONE);
            client.execute(this.createStandard1StatementCQL3(settings), ConsistencyLevel.LOCAL_ONE);
            client.execute(this.createCounter1StatementCQL3(settings), ConsistencyLevel.LOCAL_ONE);
            System.out.println(String.format("Created keyspaces. Sleeping %ss for propagation.", settings.node.nodes.size()));
            Thread.sleep((long)settings.node.nodes.size() * 1000L);
        }
        catch (AlreadyExistsException alreadyExistsException) {
        }
        catch (Exception e) {
            throw new RuntimeException("Encountered exception creating schema", e);
        }
    }

    String createKeyspaceStatementCQL3() {
        StringBuilder b = new StringBuilder();
        b.append("CREATE KEYSPACE IF NOT EXISTS \"").append(this.keyspace).append("\" WITH replication = {'class': '").append(this.replicationStrategy).append("'");
        if (this.replicationStrategyOptions.isEmpty()) {
            b.append(", 'replication_factor': '1'}");
        } else {
            for (Map.Entry<String, String> entry : this.replicationStrategyOptions.entrySet()) {
                b.append(", '").append(entry.getKey()).append("' : '").append(entry.getValue()).append("'");
            }
            b.append("}");
        }
        b.append(" AND durable_writes = true;\n");
        return b.toString();
    }

    String createStandard1StatementCQL3(StressSettings settings) {
        StringBuilder b = new StringBuilder();
        b.append("CREATE TABLE IF NOT EXISTS ").append("standard1 (key blob PRIMARY KEY ");
        try {
            for (ByteBuffer byteBuffer : settings.columns.names) {
                b.append("\n, \"").append(ByteBufferUtil.string((ByteBuffer)byteBuffer)).append("\" blob");
            }
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException(e);
        }
        b.append(") WITH compression = {");
        if (this.compression != null) {
            b.append("'sstable_compression' : '").append(this.compression).append("'");
        }
        b.append("}");
        if (this.compactionStrategy != null) {
            b.append(" AND compaction = { 'class' : '").append(this.compactionStrategy).append("'");
            for (Map.Entry entry : this.compactionStrategyOptions.entrySet()) {
                b.append(", '").append((String)entry.getKey()).append("' : '").append((String)entry.getValue()).append("'");
            }
            b.append("}");
        }
        b.append(";\n");
        return b.toString();
    }

    String createCounter1StatementCQL3(StressSettings settings) {
        StringBuilder b = new StringBuilder();
        b.append("CREATE TABLE IF NOT EXISTS ").append("counter1 (key blob PRIMARY KEY,");
        try {
            for (ByteBuffer byteBuffer : settings.columns.names) {
                b.append("\n, \"").append(ByteBufferUtil.string((ByteBuffer)byteBuffer)).append("\" counter");
            }
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException(e);
        }
        b.append(") WITH compression = {");
        if (this.compression != null) {
            b.append("'sstable_compression' : '").append(this.compression).append("'");
        }
        b.append("}");
        if (this.compactionStrategy != null) {
            b.append(" AND compaction = { 'class' : '").append(this.compactionStrategy).append("'");
            for (Map.Entry entry : this.compactionStrategyOptions.entrySet()) {
                b.append(", '").append((String)entry.getKey()).append("' : '").append((String)entry.getValue()).append("'");
            }
            b.append("}");
        }
        b.append(";\n");
        return b.toString();
    }

    public void printSettings(ResultLogger out) {
        out.println("  Keyspace: " + this.keyspace);
        out.println("  Replication Strategy: " + this.replicationStrategy);
        out.println("  Replication Strategy Options: " + this.replicationStrategyOptions);
        out.println("  Table Compression: " + this.compression);
        out.println("  Table Compaction Strategy: " + this.compactionStrategy);
        out.println("  Table Compaction Strategy Options: " + this.compactionStrategyOptions);
    }

    public static SettingsSchema get(Map<String, String[]> clArgs, SettingsCommand command) {
        String[] params = clArgs.remove("-schema");
        if (params == null) {
            return new SettingsSchema(new Options(), command);
        }
        if (command instanceof SettingsCommandUser) {
            throw new IllegalArgumentException("-schema can only be provided with predefined operations insert, read, etc.; the 'user' command requires a schema yaml instead");
        }
        GroupedOptions options = GroupedOptions.select((String[])params, (GroupedOptions[])new Options[]{new Options()});
        if (options == null) {
            SettingsSchema.printHelp();
            System.out.println("Invalid -schema options provided, see output for valid options");
            System.exit(1);
        }
        return new SettingsSchema((Options)options, command);
    }

    public static void printHelp() {
        GroupedOptions.printOptions(System.out, "-schema", new Options());
    }

    public static Runnable helpPrinter() {
        return new Runnable(){

            @Override
            public void run() {
                SettingsSchema.printHelp();
            }
        };
    }

    private static final class Options
    extends GroupedOptions {
        final OptionReplication replication = new OptionReplication();
        final OptionCompaction compaction = new OptionCompaction();
        final OptionSimple keyspace = new OptionSimple("keyspace=", ".*", "keyspace1", "The keyspace name to use", false);
        final OptionSimple compression = new OptionSimple("compression=", ".*", null, "Specify the compression to use for sstable, default:no compression", false);

        private Options() {
        }

        @Override
        public List<? extends Option> options() {
            return Arrays.asList(this.replication, this.keyspace, this.compaction, this.compression);
        }
    }
}

