/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.tools.nodetool.HostStatWithPort;

public class SetHostStatWithPort
implements Iterable<HostStatWithPort> {
    final List<HostStatWithPort> hostStats = new ArrayList<HostStatWithPort>();
    final boolean resolveIp;

    public SetHostStatWithPort(boolean resolveIp) {
        this.resolveIp = resolveIp;
    }

    public int size() {
        return this.hostStats.size();
    }

    @Override
    public Iterator<HostStatWithPort> iterator() {
        return this.hostStats.iterator();
    }

    public void add(String token, String host, Map<String, Float> ownerships) throws UnknownHostException {
        InetAddressAndPort endpoint = InetAddressAndPort.getByName(host);
        Float owns = ownerships.get(endpoint.getHostAddressAndPort());
        this.hostStats.add(new HostStatWithPort(token, endpoint, this.resolveIp, owns));
    }
}

