/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.concurrenttrees.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class Iterables {
    public static <T> List<T> toList(Iterable<T> iterable) {
        if (iterable instanceof Collection) {
            return new ArrayList((Collection)iterable);
        }
        LinkedList<T> list = new LinkedList<T>();
        for (T element : iterable) {
            list.add(element);
        }
        return list;
    }

    public static <T> Set<T> toSet(Iterable<T> iterable) {
        if (iterable instanceof Collection) {
            return new LinkedHashSet((Collection)iterable);
        }
        LinkedHashSet<T> list = new LinkedHashSet<T>();
        for (T element : iterable) {
            list.add(element);
        }
        return list;
    }

    public static String toString(Iterable<?> iterable) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        Iterator<?> i = iterable.iterator();
        while (i.hasNext()) {
            sb.append(i.next());
            if (!i.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    public static int count(Iterable<?> iterable) {
        int count = 0;
        for (Object next : iterable) {
            ++count;
        }
        return count;
    }

    Iterables() {
    }
}

