/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	camelv1 "github.com/apache/camel-k/v2/pkg/apis/camel/v1"
)

// BuildConfigurationApplyConfiguration represents a declarative configuration of the BuildConfiguration type for use
// with apply.
type BuildConfigurationApplyConfiguration struct {
	ToolImage           *string                     `json:"toolImage,omitempty"`
	BuilderPodNamespace *string                     `json:"operatorNamespace,omitempty"`
	Strategy            *camelv1.BuildStrategy      `json:"strategy,omitempty"`
	OrderStrategy       *camelv1.BuildOrderStrategy `json:"orderStrategy,omitempty"`
	RequestCPU          *string                     `json:"requestCPU,omitempty"`
	RequestMemory       *string                     `json:"requestMemory,omitempty"`
	LimitCPU            *string                     `json:"limitCPU,omitempty"`
	LimitMemory         *string                     `json:"limitMemory,omitempty"`
	NodeSelector        map[string]string           `json:"nodeSelector,omitempty"`
	Annotations         map[string]string           `json:"annotations,omitempty"`
	ImagePlatforms      []string                    `json:"platforms,omitempty"`
}

// BuildConfigurationApplyConfiguration constructs a declarative configuration of the BuildConfiguration type for use with
// apply.
func BuildConfiguration() *BuildConfigurationApplyConfiguration {
	return &BuildConfigurationApplyConfiguration{}
}

// WithToolImage sets the ToolImage field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ToolImage field is set to the value of the last call.
func (b *BuildConfigurationApplyConfiguration) WithToolImage(value string) *BuildConfigurationApplyConfiguration {
	b.ToolImage = &value
	return b
}

// WithBuilderPodNamespace sets the BuilderPodNamespace field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the BuilderPodNamespace field is set to the value of the last call.
func (b *BuildConfigurationApplyConfiguration) WithBuilderPodNamespace(value string) *BuildConfigurationApplyConfiguration {
	b.BuilderPodNamespace = &value
	return b
}

// WithStrategy sets the Strategy field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Strategy field is set to the value of the last call.
func (b *BuildConfigurationApplyConfiguration) WithStrategy(value camelv1.BuildStrategy) *BuildConfigurationApplyConfiguration {
	b.Strategy = &value
	return b
}

// WithOrderStrategy sets the OrderStrategy field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the OrderStrategy field is set to the value of the last call.
func (b *BuildConfigurationApplyConfiguration) WithOrderStrategy(value camelv1.BuildOrderStrategy) *BuildConfigurationApplyConfiguration {
	b.OrderStrategy = &value
	return b
}

// WithRequestCPU sets the RequestCPU field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the RequestCPU field is set to the value of the last call.
func (b *BuildConfigurationApplyConfiguration) WithRequestCPU(value string) *BuildConfigurationApplyConfiguration {
	b.RequestCPU = &value
	return b
}

// WithRequestMemory sets the RequestMemory field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the RequestMemory field is set to the value of the last call.
func (b *BuildConfigurationApplyConfiguration) WithRequestMemory(value string) *BuildConfigurationApplyConfiguration {
	b.RequestMemory = &value
	return b
}

// WithLimitCPU sets the LimitCPU field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the LimitCPU field is set to the value of the last call.
func (b *BuildConfigurationApplyConfiguration) WithLimitCPU(value string) *BuildConfigurationApplyConfiguration {
	b.LimitCPU = &value
	return b
}

// WithLimitMemory sets the LimitMemory field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the LimitMemory field is set to the value of the last call.
func (b *BuildConfigurationApplyConfiguration) WithLimitMemory(value string) *BuildConfigurationApplyConfiguration {
	b.LimitMemory = &value
	return b
}

// WithNodeSelector puts the entries into the NodeSelector field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the NodeSelector field,
// overwriting an existing map entries in NodeSelector field with the same key.
func (b *BuildConfigurationApplyConfiguration) WithNodeSelector(entries map[string]string) *BuildConfigurationApplyConfiguration {
	if b.NodeSelector == nil && len(entries) > 0 {
		b.NodeSelector = make(map[string]string, len(entries))
	}
	for k, v := range entries {
		b.NodeSelector[k] = v
	}
	return b
}

// WithAnnotations puts the entries into the Annotations field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the Annotations field,
// overwriting an existing map entries in Annotations field with the same key.
func (b *BuildConfigurationApplyConfiguration) WithAnnotations(entries map[string]string) *BuildConfigurationApplyConfiguration {
	if b.Annotations == nil && len(entries) > 0 {
		b.Annotations = make(map[string]string, len(entries))
	}
	for k, v := range entries {
		b.Annotations[k] = v
	}
	return b
}

// WithImagePlatforms adds the given value to the ImagePlatforms field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the ImagePlatforms field.
func (b *BuildConfigurationApplyConfiguration) WithImagePlatforms(values ...string) *BuildConfigurationApplyConfiguration {
	for i := range values {
		b.ImagePlatforms = append(b.ImagePlatforms, values[i])
	}
	return b
}
