/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.bigtop.manager.dao.repository;

import org.apache.bigtop.manager.dao.po.HostPO;
import org.apache.bigtop.manager.dao.query.HostQuery;

import org.apache.ibatis.annotations.Param;

import java.util.Collection;
import java.util.List;

public interface HostDao extends BaseDao<HostPO> {

    List<HostPO> findByQuery(@Param("query") HostQuery query);

    HostPO findDetailsById(@Param("id") Long id);

    HostPO findByHostname(@Param("hostname") String hostname);

    List<HostPO> findAllByHostnames(@Param("hostnames") Collection<String> hostnames);

    List<HostPO> findAllByClusterId(@Param("clusterId") Long clusterId);
}
