/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.sjavac.server;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.nio.file.Path;
import org.openjdk.tools.javac.main.Main;
import org.openjdk.tools.sjavac.Log;
import org.openjdk.tools.sjavac.Util;
import org.openjdk.tools.sjavac.server.ServerMain;
import org.openjdk.tools.sjavac.server.Sjavac;

public class RequestHandler
extends Thread {
    private final Socket socket;
    private final Sjavac sjavac;

    public RequestHandler(Socket socket, Sjavac sjavac) {
        this.socket = socket;
        this.sjavac = sjavac;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
             PrintWriter printWriter = new PrintWriter(this.socket.getOutputStream(), true);){
            Log.setLogForCurrentThread(new Log(printWriter, printWriter){

                @Override
                protected boolean isLevelLogged(Log.Level level) {
                    return true;
                }

                @Override
                protected void printLogMsg(Log.Level level, String string2) {
                    Util.getLines(string2).map(string -> (Object)((Object)level) + ":" + string).forEach(string -> super.printLogMsg(level, (String)string));
                }
            });
            int n = Integer.parseInt(bufferedReader.readLine());
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = bufferedReader.readLine();
            }
            this.checkInternalErrorLog();
            Main.Result result = this.sjavac.compile(stringArray);
            printWriter.println("RC:" + result.name());
            this.checkInternalErrorLog();
        }
        catch (Exception exception) {
            Log.error(exception);
        }
        finally {
            Log.setLogForCurrentThread(null);
        }
    }

    private void checkInternalErrorLog() {
        Path path = ServerMain.getErrorLog().getLogDestination();
        if (path != null) {
            Log.error("Server has encountered an internal error. See " + path.toAbsolutePath() + " for details.");
        }
    }
}

