/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.core.stream.sax.output;

import java.io.IOException;
import java.io.Writer;
import java.util.Stack;
import org.apache.axiom.core.stream.CharacterData;
import org.apache.axiom.core.stream.CharacterDataSink;
import org.apache.axiom.core.stream.StreamException;
import org.apache.axiom.core.stream.XmlHandler;
import org.apache.axiom.core.stream.sax.output.ContentHandlerWriter;
import org.apache.axiom.core.stream.util.CharacterDataAccumulator;
import org.apache.axiom.util.base64.AbstractBase64EncodingOutputStream;
import org.apache.axiom.util.base64.Base64EncodingWriterOutputStream;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class ContentHandlerXmlHandler
implements XmlHandler,
CharacterDataSink {
    private final ContentHandler contentHandler;
    private final LexicalHandler lexicalHandler;
    private String[] prefixStack = new String[16];
    private int bindings;
    private int[] scopeStack = new int[8];
    private int depth;
    private Stack<String> elementNameStack = new Stack();
    private String elementURI;
    private String elementLocalName;
    private String elementQName;
    private final AttributesImpl attributes = new AttributesImpl();
    private CharacterDataMode characterDataMode = CharacterDataMode.PASS_THROUGH;
    private char[] buffer = new char[4096];
    private int bufferPos;
    private CharacterDataAccumulator accumulator;
    private String piTarget;

    public ContentHandlerXmlHandler(ContentHandler contentHandler, LexicalHandler lexicalHandler) {
        this.contentHandler = contentHandler;
        this.lexicalHandler = lexicalHandler;
    }

    private static String getQName(String prefix, String localName) {
        if (prefix.length() == 0) {
            return localName;
        }
        return prefix + ":" + localName;
    }

    @Override
    public void startDocument(String inputEncoding, String xmlVersion, String xmlEncoding, Boolean standalone) throws StreamException {
        try {
            this.contentHandler.startDocument();
        }
        catch (SAXException ex) {
            throw new StreamException(ex);
        }
    }

    @Override
    public void startFragment() throws StreamException {
        try {
            this.contentHandler.startDocument();
        }
        catch (SAXException ex) {
            throw new StreamException(ex);
        }
    }

    @Override
    public void processDocumentTypeDeclaration(String rootName, String publicId, String systemId, String internalSubset) throws StreamException {
        if (this.lexicalHandler != null) {
            try {
                this.lexicalHandler.startDTD(rootName, publicId, systemId);
                this.lexicalHandler.endDTD();
            }
            catch (SAXException ex) {
                throw new StreamException(ex);
            }
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String prefix) throws StreamException {
        this.elementURI = namespaceURI;
        this.elementLocalName = localName;
        this.elementQName = ContentHandlerXmlHandler.getQName(prefix, localName);
        if (this.depth == this.scopeStack.length) {
            int[] newScopeStack = new int[this.scopeStack.length * 2];
            System.arraycopy(this.scopeStack, 0, newScopeStack, 0, this.scopeStack.length);
            this.scopeStack = newScopeStack;
        }
        this.scopeStack[this.depth++] = this.bindings;
    }

    @Override
    public void processNamespaceDeclaration(String prefix, String namespaceURI) throws StreamException {
        if (this.bindings == this.prefixStack.length) {
            String[] newPrefixStack = new String[this.prefixStack.length * 2];
            System.arraycopy(this.prefixStack, 0, newPrefixStack, 0, this.prefixStack.length);
            this.prefixStack = newPrefixStack;
        }
        this.prefixStack[this.bindings++] = prefix;
        try {
            this.contentHandler.startPrefixMapping(prefix, namespaceURI);
        }
        catch (SAXException ex) {
            throw new StreamException(ex);
        }
    }

    @Override
    public void processAttribute(String namespaceURI, String localName, String prefix, String value, String type, boolean specified) throws StreamException {
        this.attributes.addAttribute(namespaceURI, localName, ContentHandlerXmlHandler.getQName(prefix, localName), type, value);
    }

    @Override
    public void processAttribute(String name, String value, String type, boolean specified) throws StreamException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void attributesCompleted() throws StreamException {
        try {
            this.contentHandler.startElement(this.elementURI, this.elementLocalName, this.elementQName, this.attributes);
            this.elementNameStack.push(this.elementURI);
            this.elementNameStack.push(this.elementLocalName);
            this.elementNameStack.push(this.elementQName);
            this.elementURI = null;
            this.elementLocalName = null;
            this.elementQName = null;
            this.attributes.clear();
        }
        catch (SAXException ex) {
            throw new StreamException(ex);
        }
    }

    @Override
    public void endElement() throws StreamException {
        try {
            String elementQName = this.elementNameStack.pop();
            String elementLocalName = this.elementNameStack.pop();
            String elementURI = this.elementNameStack.pop();
            this.contentHandler.endElement(elementURI, elementLocalName, elementQName);
            for (int i = this.bindings - 1; i >= this.scopeStack[this.depth - 1]; --i) {
                this.contentHandler.endPrefixMapping(this.prefixStack[i]);
            }
            this.bindings = this.scopeStack[--this.depth];
        }
        catch (SAXException ex) {
            throw new StreamException(ex);
        }
    }

    private void writeToBuffer(String data) {
        int dataLen = data.length();
        if (this.buffer.length - this.bufferPos < dataLen) {
            int newLength = this.buffer.length;
            while ((newLength *= 2) - this.bufferPos < dataLen) {
            }
            char[] newBuffer = new char[newLength];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.bufferPos);
            this.buffer = newBuffer;
        }
        data.getChars(0, dataLen, this.buffer, this.bufferPos);
        this.bufferPos += dataLen;
    }

    @Override
    public Writer getWriter() {
        return new ContentHandlerWriter(this.contentHandler);
    }

    @Override
    public AbstractBase64EncodingOutputStream getBase64EncodingOutputStream() {
        return new Base64EncodingWriterOutputStream(this.getWriter());
    }

    @Override
    public void processCharacterData(Object data, boolean ignorable) throws StreamException {
        try {
            switch (this.characterDataMode) {
                case PASS_THROUGH: {
                    if (ignorable) {
                        this.writeToBuffer(data.toString());
                        this.contentHandler.ignorableWhitespace(this.buffer, 0, this.bufferPos);
                        this.bufferPos = 0;
                        break;
                    }
                    if (data instanceof CharacterData) {
                        try {
                            ((CharacterData)data).writeTo(this);
                            break;
                        }
                        catch (IOException ex) {
                            Throwable cause = ex.getCause();
                            SAXException saxException = cause instanceof SAXException ? (SAXException)cause : new SAXException(ex);
                            throw new StreamException(saxException);
                        }
                    }
                    this.writeToBuffer(data.toString());
                    this.contentHandler.characters(this.buffer, 0, this.bufferPos);
                    this.bufferPos = 0;
                    break;
                }
                case BUFFER: {
                    this.writeToBuffer(data.toString());
                    break;
                }
                case ACCUMULATE: {
                    this.accumulator.append(data);
                    break;
                }
            }
        }
        catch (SAXException ex) {
            throw new StreamException(ex);
        }
    }

    @Override
    public void startCDATASection() throws StreamException {
        try {
            if (this.lexicalHandler != null) {
                this.lexicalHandler.startCDATA();
            }
        }
        catch (SAXException ex) {
            throw new StreamException(ex);
        }
    }

    @Override
    public void endCDATASection() throws StreamException {
        try {
            if (this.lexicalHandler != null) {
                this.lexicalHandler.endCDATA();
            }
        }
        catch (SAXException ex) {
            throw new StreamException(ex);
        }
    }

    @Override
    public void startComment() throws StreamException {
        this.characterDataMode = this.lexicalHandler == null ? CharacterDataMode.SKIP : CharacterDataMode.BUFFER;
    }

    @Override
    public void endComment() throws StreamException {
        if (this.lexicalHandler != null) {
            try {
                this.lexicalHandler.comment(this.buffer, 0, this.bufferPos);
                this.bufferPos = 0;
            }
            catch (SAXException ex) {
                throw new StreamException(ex);
            }
        }
        this.characterDataMode = CharacterDataMode.PASS_THROUGH;
    }

    @Override
    public void startProcessingInstruction(String target) throws StreamException {
        if (this.accumulator == null) {
            this.accumulator = new CharacterDataAccumulator();
        }
        this.piTarget = target;
        this.characterDataMode = CharacterDataMode.ACCUMULATE;
    }

    @Override
    public void endProcessingInstruction() throws StreamException {
        try {
            this.contentHandler.processingInstruction(this.piTarget, this.accumulator.toString());
            this.accumulator.clear();
            this.piTarget = null;
            this.characterDataMode = CharacterDataMode.PASS_THROUGH;
        }
        catch (SAXException ex) {
            throw new StreamException(ex);
        }
    }

    @Override
    public void processEntityReference(String name, String replacementText) throws StreamException {
        try {
            this.contentHandler.skippedEntity(name);
        }
        catch (SAXException ex) {
            throw new StreamException(ex);
        }
    }

    @Override
    public void completed() throws StreamException {
        try {
            this.contentHandler.endDocument();
        }
        catch (SAXException ex) {
            throw new StreamException(ex);
        }
    }

    @Override
    public boolean drain() throws StreamException {
        return true;
    }

    private static enum CharacterDataMode {
        PASS_THROUGH,
        BUFFER,
        SKIP,
        ACCUMULATE;

    }
}

