/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.compaction;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.accumulo.core.client.admin.compaction.CompactableFile;
import org.apache.accumulo.core.spi.compaction.CompactionExecutorId;
import org.apache.accumulo.core.spi.compaction.CompactionJob;
import org.apache.accumulo.core.spi.compaction.CompactionKind;
import org.apache.accumulo.core.spi.compaction.CompactionPlan;
import org.apache.accumulo.core.util.compaction.CompactionJobImpl;

public class CompactionPlanImpl
implements CompactionPlan {
    private final Collection<CompactionJob> jobs;

    private CompactionPlanImpl(Collection<CompactionJob> jobs) {
        this.jobs = List.copyOf(jobs);
    }

    @Override
    public Collection<CompactionJob> getJobs() {
        return this.jobs;
    }

    public String toString() {
        return "jobs: " + String.valueOf(this.jobs);
    }

    public static class BuilderImpl
    implements CompactionPlan.Builder {
        private final CompactionKind kind;
        private final ArrayList<CompactionJob> jobs = new ArrayList();
        private final Set<CompactableFile> allFiles;
        private final Set<CompactableFile> seenFiles = new HashSet<CompactableFile>();
        private final Set<CompactableFile> candidates;

        public BuilderImpl(CompactionKind kind, Set<CompactableFile> allFiles, Set<CompactableFile> candidates) {
            this.kind = kind;
            this.allFiles = allFiles;
            this.candidates = candidates;
        }

        @Override
        public CompactionPlan.Builder addJob(short priority, CompactionExecutorId executor, Collection<CompactableFile> files) {
            Set<CompactableFile> filesSet = files instanceof Set ? (Set<CompactableFile>)files : Set.copyOf(files);
            Preconditions.checkArgument((boolean)Collections.disjoint(filesSet, this.seenFiles), (String)"Job files overlaps with previous job %s %s", files, this.jobs);
            Preconditions.checkArgument((boolean)this.candidates.containsAll(filesSet), (String)"Job files are not compaction candidates %s %s", files, this.candidates);
            this.seenFiles.addAll(filesSet);
            this.jobs.add(new CompactionJobImpl(priority, executor, filesSet, this.kind, Optional.of(filesSet.equals(this.allFiles))));
            return this;
        }

        @Override
        public CompactionPlan build() {
            return new CompactionPlanImpl(this.jobs);
        }
    }
}

