/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.tableOps.tableImport;

import java.io.IOException;
import java.util.Set;
import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.manager.tableOps.ManagerRepo;
import org.apache.accumulo.manager.tableOps.tableImport.ImportedTableInfo;
import org.apache.accumulo.manager.tableOps.tableImport.MapImportFileNames;
import org.apache.accumulo.server.tablets.UniqueNameAllocator;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CreateImportDir
extends ManagerRepo {
    private static final Logger log = LoggerFactory.getLogger(CreateImportDir.class);
    private static final long serialVersionUID = 1L;
    private final ImportedTableInfo tableInfo;

    CreateImportDir(ImportedTableInfo ti) {
        this.tableInfo = ti;
    }

    @Override
    public Repo<Manager> call(long tid, Manager manager) throws Exception {
        Set tableDirs = manager.getContext().getTablesDirs();
        this.create(tableDirs, manager);
        return new MapImportFileNames(this.tableInfo);
    }

    void create(Set<String> tableDirs, Manager manager) throws IOException {
        UniqueNameAllocator namer = manager.getContext().getUniqueNameAllocator();
        for (ImportedTableInfo.DirectoryMapping dm : this.tableInfo.directories) {
            Path exportDir = new Path(dm.exportDir);
            log.info("Looking for matching filesystem for {} from options {}", (Object)exportDir, tableDirs);
            Path base = manager.getVolumeManager().matchingFileSystem(exportDir, tableDirs);
            if (base == null) {
                throw new IOException(dm.exportDir + " is not in the same file system as any volume configured for Accumulo");
            }
            log.info("Chose base table directory of {}", (Object)base);
            Path directory = new Path(base, this.tableInfo.tableId.canonical());
            Path newBulkDir = new Path(directory, "b-" + namer.getNextName());
            dm.importDir = newBulkDir.toString();
            log.info("Using import dir: {}", (Object)dm.importDir);
        }
    }
}

